/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.scrp.fx;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.scrp.fx.ScrpScriptPane;
import jp.co.extreme.module.scrp.fx.ScrpScriptTableModel;
import jp.co.extreme.module.scrp.model.ScrpScript;
import jp.co.extreme.module.scrp.stub.ScrpScriptStub;
import jp.co.extreme.script.SrpWords;

public class ScrpScriptTablePane
extends FxDecoratePane {
    List<ScrpScript> scriptList;
    TabPane tabPane1 = new TabPane();
    protected Button addButton;
    protected Button editButton;
    protected Button deleteButton;
    protected Button closeButton;
    Number nextRowId;
    protected Stage stage;

    public ScrpScriptTablePane() throws Exception {
        this.addButton = this.createButton(BcWords.getInstance().add);
        this.editButton = this.createButton(BcWords.getInstance().edit);
        this.deleteButton = this.createButton(BcWords.getInstance().delete);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.scriptList = ScrpScriptStub.getInstance().getScriptList();
        ScrpScriptTableModel scriptTableModel = new ScrpScriptTableModel(this.scriptList);
        FxTableRowList tableRowList = new FxTableRowList(scriptTableModel);
        InnerTableView tableView = new InnerTableView();
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        tableView.setItems(tableRowList);
        Tab scriptTab = new Tab();
        scriptTab.setText(SrpWords.getInstance().script);
        scriptTab.setContent((Node)tableView);
        scriptTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)scriptTab);
        this.tabPane1.setSide(Side.TOP);
        this.setCenter((Node)this.tabPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = SrpWords.getInstance().scriptName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 80;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.addButton) {
            ScrpScriptPane scrpScriptPane = new ScrpScriptPane();
        } else if (ev.getSource() == this.editButton) {
            ScrpScript script = this.scriptList.get(this.nextRowId.intValue());
            ScrpScriptPane scrpScriptPane = new ScrpScriptPane();
        } else if (ev.getSource() == this.deleteButton) {
            ScrpScript script = this.scriptList.get(this.nextRowId.intValue());
            ScrpScriptStub.getInstance().getScriptList();
            ScrpScriptPane scrpScriptPane = new ScrpScriptPane();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public void show() throws Exception {
        FxScene scene = new FxScene((Parent)this);
        this.stage = new FxStage();
        this.stage.setScene((Scene)scene);
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    ScrpScriptTablePane.this.close();
                }
                catch (Exception ex) {
                    ScrpScriptTablePane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        FxUtil.setWindowSize((Window)this.stage, 600.0, 600.0, true);
        this.stage.setTitle(SrpWords.getInstance().script);
        this.stage.show();
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            ScrpScriptTablePane.this.nextRowId = nextRowId;
        }
    }
}

