/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.rmo;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.impt.common.ImptImportDefineParser;
import jp.co.extreme.module.impt.dao.ImptDefineIndexDAO;
import jp.co.extreme.module.impt.dao.ImptFileResourceDAO;
import jp.co.extreme.module.impt.model.ImptDefineIndex;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf5.model.ScfFileResource;
import jp.co.extreme.sql.model.SqlSelectQuery;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ImptDefineIndexRMO
extends RmiAbstractRMO {
    public static final String METHOD_putDefineIndex = "putDefineIndex";
    public static final String METHOD_deleteDefineIndex = "deleteDefineIndex";
    public static final String METHOD_getDefineIndex = "getDefineIndex";
    public static final String METHOD_defineIndexTable = "defineIndexTable";

    public void putDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        ImptDefineIndex defineIndex = (ImptDefineIndex)rmoArg.getRequest().getData();
        String fileName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        if (!BcStringUtil.isEmpty(fileName)) {
            File dir = new File(ApApplication.getInstance().toReal("${APP}temp/"));
            File file = new File(dir, fileName);
            ScfFileResource fileResource = defineIndex.fileResourceId <= 0 ? new ScfFileResource() : ImptFileResourceDAO.getInstance().getFileResource(dtsSession, defineIndex.fileResourceId);
            ImptFileResourceDAO.getInstance().putFileResource(dtsSession, fileResource, file);
            defineIndex.fileResourceId = fileResource.getDataId();
        }
        ImptDefineIndexDAO.getInstance().putDefineIndex(dtsSession, defineIndex);
        rmoArg.getRespons().addData(defineIndex.getDataId());
    }

    public void deleteDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int cnt = ImptDefineIndexDAO.getInstance().deleteDefineIndex(dtsSession, defineIndexId);
        rmoArg.getRespons().addData(cnt);
    }

    public void getDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ImptDefineIndex defineIndex = ImptDefineIndexDAO.getInstance().getDefineIndex(dtsSession, defineIndexId);
        String fileName = rmoArg.getRequest().getDataAsString();
        rmoArg.getRespons().addData(defineIndex);
    }

    public void defineIndexTable(RmiRmoArgument rmoArg) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.addSelectColumn("impt_define_index.id");
        selectQuery.addSelectColumn("impt_define_index.code");
        selectQuery.addSelectColumn("impt_define_index.name");
        selectQuery.addSelectColumn("impt_define_index.file_resource_id");
        selectQuery.addSelectColumn("impt_define_index.class_id");
        selectQuery.addSelectColumn("impt_define_index.display_no");
        selectQuery.addSelectColumn("impt_define_index.note_");
        selectQuery.setFromClause("impt_define_index__vv AS impt_define_index");
        ScfSqlUtil.generalList(rmoArg, selectQuery);
    }

    public void getDefineIndexList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<ImptDefineIndex> importModeList = new ArrayList<ImptDefineIndex>();
        List<ImptDefineIndex> defineIndexList2 = ImptDefineIndexDAO.getInstance().getDefineIndexList(dtsSession);
        importModeList.addAll(defineIndexList2);
        rmoArg.getRespons().addData(importModeList);
    }

    public void getFileResource(RmiRmoArgument rmoArg) throws Exception {
        int fileResourceId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfFileResource fileResource = ImptFileResourceDAO.getInstance().getFileResource(dtsSession, fileResourceId);
        rmoArg.getRespons().addData(fileResource);
    }

    public void getImportDefine(RmiRmoArgument rmoArg) throws Exception {
        int fileResourceId = rmoArg.getRequest().getDataAsInteger();
        BcLogUtil.debug("getImportDefine:fileResourceId=" + fileResourceId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        byte[] bytes = ImptFileResourceDAO.getInstance().getAsByteArray(dtsSession.getConnection(), fileResourceId);
        ImptImportDefine importDefine = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            InputSource inputSource = new InputSource(is);
            Document domDoc = BcXmlUtil.createDocument(inputSource);
            ImptImportDefineParser importDefineParser = new ImptImportDefineParser();
            importDefine = importDefineParser.parse(domDoc);
        }
        rmoArg.getRespons().addData(importDefine);
    }
}

