/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.common;

import java.io.File;
import java.io.FileInputStream;
import javax.script.Compilable;
import javax.script.ScriptEngineManager;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.module.impt.model.ImptMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImptImportDefineParser {
    public static final String DATASOURCE_TYPE_csv = "CSV";
    public static final String DATASOURCE_TYPE_fixedLength = "FIXED_LENGTH";
    public static final String DATASOURCE_TYPE_excelBook = "EXCEL_BOOK";
    public static final String TAG_importDefine = "importDefine";
    public static final String TAG_datasource = "datasource";
    public static final String TAG_type = "type";
    public static final String TAG_encoding = "encoding";
    public static final String TAG_control = "control";
    public static final String TAG_headerRow = "headerRow";
    public static final String TAG_dataStartRow = "dataStartRow";
    public static final String TAG_dataEndRow = "dataEndRow";
    public static final String TAG_updateMode = "updateMode";
    public static final String TAG_property = "property";
    public static final String TAG_column = "column";
    public static final String TAG_sourceName = "sourceName";
    public static final String TAG_size = "size";
    public static final String TAG_format = "format";
    public static final String TAG_mapping = "mapping";
    public static final String TAG_name = "name";
    public static final String TAG_fractionDigits = "fractionDigits";
    public static final String TAG_length = "length";
    public static final String TAG_prefix = "prefix";
    public static final String TAG_defaultValue = "defaultValue";
    public static final String TAG_replace = "replace";
    public static final String TAG_exponent = "exponent";
    public static final String TAG_script = "script";
    public static final String ATRIB_engine = "engine";

    public ImptImportDefine parse(File file, String encode) throws Exception {
        ImptImportDefine importDefine = null;
        try (FileInputStream is = new FileInputStream(file);){
            InputSource inputSource = new InputSource(is);
            if (!BcStringUtil.isEmpty(encode)) {
                inputSource.setEncoding(encode);
            }
            Document domDoc = BcXmlUtil.createDocument(inputSource);
            importDefine = this.parse(domDoc);
        }
        return importDefine;
    }

    public ImptImportDefine parse(File file) throws Exception {
        return this.parse(file, null);
    }

    public ImptImportDefine parse(Document domDoc) throws Exception {
        ImptImportDefine importDefine = new ImptImportDefine();
        Element nodeRoot = domDoc.getDocumentElement();
        this.parseRootNode(nodeRoot, importDefine);
        importDefine.packData();
        return importDefine;
    }

    protected void parseRootNode(Node nodeRoot, ImptImportDefine importDefine) throws Exception {
        if (!nodeRoot.getNodeName().equals(TAG_importDefine)) {
            throw new Exception("unknown root tag");
        }
        this.parseNode(nodeRoot, importDefine);
    }

    protected void parseNode(Node node, ImptImportDefine importDefine) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            String value;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(TAG_datasource)) {
                this.parseDatasorceTag(node2, importDefine);
            } else if (node2.getNodeName().equals(TAG_property)) {
                String propName = BcXmlUtil.getAttribute(node2, TAG_name);
                String propValue = BcXmlUtil.getAttribute(node2, "value");
                importDefine.props.setProperty(propName, propValue);
            } else if (node2.getNodeName().equals(TAG_control)) {
                this.parseControlNode(node2, importDefine);
            } else if (node2.getNodeName().equals(TAG_headerRow)) {
                value = BcXmlUtil.getTextValue(node2);
                importDefine.headerRow = BcNumberUtil.parseInt(value, -1);
            } else if (node2.getNodeName().equals(TAG_dataStartRow)) {
                value = BcXmlUtil.getTextValue(node2);
                importDefine.dataStartRow = BcNumberUtil.parseInt(value, -1);
            } else if (node2.getNodeName().equals(TAG_dataEndRow)) {
                value = BcXmlUtil.getTextValue(node2);
                importDefine.dataEndRow = BcNumberUtil.parseInt(value, -1);
            } else if (node2.getNodeName().equals(TAG_updateMode)) {
                value = BcXmlUtil.getTextValue(node2);
                importDefine.updateMode = BcNumberUtil.parseInt(value, -1);
            } else if (node2.getNodeName().equals(TAG_column)) {
                this.parseColumnNode(node2, importDefine);
            } else {
                value = BcXmlUtil.getTextValue(node2);
                if (value != null) {
                    importDefine.props.setProperty(node2.getNodeName(), value);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseDatasorceTag(Node node, ImptImportDefine importDefine) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            String value;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(TAG_type)) {
                value = BcXmlUtil.getTextValue(node2);
                if (BcStringUtil.equals(value, DATASOURCE_TYPE_csv)) {
                    importDefine.datasourceType = 11;
                } else if (BcStringUtil.equals(value, DATASOURCE_TYPE_fixedLength)) {
                    importDefine.datasourceType = 21;
                } else {
                    if (!BcStringUtil.equals(value, DATASOURCE_TYPE_excelBook)) throw new Exception("unknown datasource type '" + value + "'");
                    importDefine.datasourceType = 31;
                }
            } else if (node2.getNodeName().equals(TAG_encoding)) {
                importDefine.charsetName = value = BcXmlUtil.getTextValue(node2);
            }
            ++i;
        }
    }

    protected void parseControlNode(Node node, ImptImportDefine importDefine) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node2 = nodeList.item(i);
            importDefine.props.setProperty(node2.getNodeName(), BcXmlUtil.getTextValue(node2));
            ++i;
        }
    }

    protected void parseColumnNode(Node node, ImptImportDefine importDefine) throws Exception {
        MmdField mmdField = new MmdField();
        importDefine.addModelMetaDataField(mmdField);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(TAG_sourceName)) {
                mmdField.fieldName = BcXmlUtil.getTextValue(node2);
            } else if (node2.getNodeName().equals(TAG_size)) {
                mmdField.dataSize = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(node2), -1);
            } else if (node2.getNodeName().equals(TAG_format)) {
                mmdField.formatPattern = BcXmlUtil.getTextValue(node2);
            } else if (node2.getNodeName().equals(TAG_mapping)) {
                this.parseMappingNode(node2, importDefine, mmdField);
            }
            ++i;
        }
    }

    protected void parseMappingNode(Node node, ImptImportDefine importDefine, MmdField mmdField) throws Exception {
        ImptMapper mapper = new ImptMapper();
        mapper.mmdField = mmdField;
        mapper.updateMode = importDefine.updateMode;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            String value;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(TAG_name)) {
                mapper.name = BcXmlUtil.getTextValue(node2);
            } else if (node2.getNodeName().equals(TAG_defaultValue)) {
                mapper.defaultValue = BcXmlUtil.getTextValue(node2);
            } else if (node2.getNodeName().equals(TAG_replace)) {
                String src = BcXmlUtil.getAttribute(node2, "src");
                String to = BcXmlUtil.getAttribute(node2, "to");
                mapper.repMap.put(src, to);
            } else if (node2.getNodeName().equals(TAG_updateMode)) {
                value = BcXmlUtil.getTextValue(node2);
                if (!BcStringUtil.isEmpty(value)) {
                    try {
                        mapper.updateMode = BcNumberUtil.parseInteger(value);
                    }
                    catch (Exception ex) {
                        throw new Exception("not support value :tag='" + node2.getNodeName() + "' value='" + value + "'");
                    }
                }
            } else if (node2.getNodeName().equals(TAG_script)) {
                mapper.scriptEngineName = BcXmlUtil.getAttribute(node2, ATRIB_engine);
                mapper.script = BcXmlUtil.getTextValue(node2);
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                mapper.scriptEngine = scriptEngineManager.getEngineByName(mapper.scriptEngineName);
                if (mapper.scriptEngine instanceof Compilable) {
                    Compilable compilable = (Compilable)((Object)mapper.scriptEngine);
                    mapper.compiledScript = compilable.compile(mapper.script);
                    BcLogUtil.debug("script compiled. engine=" + mapper.scriptEngineName);
                }
            } else {
                value = BcXmlUtil.getTextValue(node2);
                if (value != null) {
                    mapper.props.setProperty(node2.getNodeName(), value);
                }
            }
            ++i;
        }
        importDefine.addMapper(mapper);
    }
}

