/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.swg;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf2.client.ScfFileDownloader;
import jp.co.extreme.scf4.swg.HswgProcessingPane;
import jp.co.extreme.swing.SwgOptionPane;

public class DcmnDocumentClientHelper {
    List<File> svFileList;
    List<File> localFileList;

    public void sendRequestAndLunchExcel(RmiRequest rmiReq, String title, Component parentComponent) throws Exception {
        HswgProcessingPane processiongPane = new HswgProcessingPane();
        processiongPane.setRequest(rmiReq);
        processiongPane.showAsDiaolg(parentComponent, title);
        RmiRespons rmiRes = processiongPane.getResponse();
        this.svFileList = (List)rmiRes.getData();
        BcLogUtil.debug("svFileList.size()=" + this.svFileList.size());
        if (this.svFileList.size() == 0) {
            return;
        }
        InnerThread downloadThread = new InnerThread();
        downloadThread.startThread();
    }

    protected void fileDownload() throws Exception {
        File localDir = new File(ApApplication.getInstance().toReal("${APP}export/"));
        BcMonitor monitor = new BcMonitor();
        this.localFileList = new ArrayList<File>();
        int i = 0;
        while (i < this.svFileList.size()) {
            File svFile = this.svFileList.get(i);
            File localFile = null;
            if (ScfClientContainer.getInstance().isClient()) {
                localFile = new File(localDir, svFile.getName());
                ScfFileDownloader fileDownloader = new ScfFileDownloader(ScfClientContainer.getInstance().getAgent());
                fileDownloader.download(monitor, svFile, localFile, false);
                monitor.sync();
            } else {
                localFile = svFile;
            }
            this.localFileList.add(localFile);
            ++i;
        }
        BcLogUtil.debug("localFileList.size()=" + this.localFileList.size());
        i = 0;
        while (i < this.localFileList.size()) {
            File localFile = this.localFileList.get(i);
            this.excelTrans_L2(localFile);
            ++i;
        }
    }

    protected void excelTrans_L2(File file) throws Exception {
        BcLogUtil.debug("excelTrans_L2:file.getPath()=" + file.getPath());
        Desktop.getDesktop().open(file);
    }

    class InnerThread
    extends BcThread {
        public InnerThread() {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            try {
                DcmnDocumentClientHelper.this.fileDownload();
                this.stopThread();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                SwgOptionPane.showMessageDialog(null, ex.getMessage(), BcWords.getInstance().error, 0);
            }
        }
    }
}

