/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.dao;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.dcmn.model.DcmnDocumentTemplate;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class DcmnDocumentTemplateDAO
extends OrmAbstractDAO<DcmnDocumentTemplate> {
    private DcmnDocumentTemplateDAO() {
        super(new DcmnDocumentTemplate[0]);
        this.setTableName("dcmn_document_template");
        this.setViewName("dcmn_document_template__v1");
    }

    public static DcmnDocumentTemplateDAO getInstance() {
        return SingletonHolder.instance;
    }

    private List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add("code");
        this.updateColumnList.add("name");
        this.updateColumnList.add("category_ids");
        this.updateColumnList.add("category_names");
        this.updateColumnList.add("note_");
        this.updateColumnList.add("file_resource_id");
        return this.updateColumnList;
    }

    public List<Object> toValueList(Object dataObject) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        DcmnDocumentTemplate documentTemplate = (DcmnDocumentTemplate)dataObject;
        valueList.add(documentTemplate.code);
        valueList.add(documentTemplate.name);
        valueList.add(documentTemplate.categoryIds);
        valueList.add(documentTemplate.categoryNames);
        valueList.add(documentTemplate.note);
        valueList.add(documentTemplate.fileResourceId);
        return valueList;
    }

    public String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        String selectColumns = this.getPersistenceProxy().createCommonSelectPhrase(this.getEntityClass(), tableAlias) + asTable2 + "code" + asTable2 + "name" + asTable2 + "category_ids" + asTable2 + "category_names" + asTable2 + "note_" + asTable2 + "file_resource_id";
        return selectColumns;
    }

    public void putDocumentTemplate(DtsSession dtsSession, DcmnDocumentTemplate documentTemplate) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(documentTemplate);
        this.getPersistenceProxy().putEntity(dtsSession, this.getTableName(), columnList, valueList, documentTemplate);
    }

    public int deleteDocumentTemplate(DtsSession dtsSession, int documentTemplateId) throws Exception {
        int resValue = this.getPersistenceProxy().physicalDeleteByDataId(dtsSession, this.getTableName(), documentTemplateId);
        return resValue;
    }

    public void getDocumentTemplate(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, DcmnDocumentTemplate documentTemplate) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, documentTemplate);
        documentTemplate.code = rs.getString(columnIndex);
        documentTemplate.name = rs.getString(columnIndex);
        documentTemplate.categoryIds = rs.getString(columnIndex);
        documentTemplate.categoryNames = rs.getString(columnIndex);
        documentTemplate.note = rs.getString(columnIndex);
        documentTemplate.fileResourceId = rs.getLong(columnIndex);
    }

    public DcmnDocumentTemplate getDocumentTemplate(DtsSession dtsSession, String query) throws Exception {
        DcmnDocumentTemplate documentTemplate = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                documentTemplate = new DcmnDocumentTemplate();
                this.getDocumentTemplate(dtsSession, rs, columnIndex, documentTemplate);
            }
            rs.close();
        }
        return documentTemplate;
    }

    public DcmnDocumentTemplate getDocumentTemplate(DtsSession dtsSession, int documentTemplateId) throws Exception {
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getViewName() + this.getPersistenceProxy().createDataIdWhereClause(documentTemplateId);
        return this.getDocumentTemplate(dtsSession, query);
    }

    public DcmnDocumentTemplate getDocumentTemplateByCode(DtsSession dtsSession, String documentTemplateCode) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getViewName() + " WHERE code" + sqlContext.toCondition_string("=", documentTemplateCode);
        return this.getDocumentTemplate(dtsSession, query);
    }

    /* synthetic */ DcmnDocumentTemplateDAO(DcmnDocumentTemplateDAO dcmnDocumentTemplateDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final DcmnDocumentTemplateDAO instance = new DcmnDocumentTemplateDAO(null);

        private SingletonHolder() {
        }
    }
}

