/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.arcv.dao;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.arcv.common.ArcvUtil;
import jp.co.extreme.module.arcv.dao.ArcvAbstractBinaryIndexDAO;
import jp.co.extreme.module.arcv.dao.ArcvAbstructBinaryGenerationDAO;
import jp.co.extreme.module.arcv.dao.ArcvBinaryHelper;
import jp.co.extreme.module.arcv.dao.ArcvServerUtil;
import jp.co.extreme.module.arcv.model.ArcvBinary;
import jp.co.extreme.module.arcv.model.ArcvBinaryGeneration;
import jp.co.extreme.module.arcv.model.ArcvBinaryIndex;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;

public class ArcvAbstractBinaryDAO
extends OrmAbstractDAO<ArcvBinary> {
    protected ArcvAbstructBinaryGenerationDAO binaryGenerationDAO;
    protected ArcvAbstractBinaryIndexDAO binaryIndexDAO;
    private String binaryColumnName;
    protected int bufSize = 4096;

    public ArcvAbstractBinaryDAO() {
        super(new ArcvBinary[0]);
        this.setBinaryColumnName("binary_data");
    }

    public String getBinaryColumnName() {
        return this.binaryColumnName;
    }

    public void setBinaryColumnName(String binaryColumnName) {
        this.binaryColumnName = binaryColumnName;
    }

    protected DtsSession getDtsSession(DtsSession dtsSession, ArcvBinaryGeneration binaryGeneration) throws Exception {
        if (binaryGeneration == null) {
            throw new Exception("BinaryGeneration is null.");
        }
        DtsSession dtsSession2 = null;
        dtsSession2 = binaryGeneration.datasourceName.equals(dtsSession.getSessionFactory().getName()) ? dtsSession : DtsSessionFactoryManegaer.getInstance().createSession(binaryGeneration.datasourceName, this);
        return dtsSession2;
    }

    public void putBinary(DtsSession dtsSession, ArcvBinary binary, InputStream is, long length, ArcvBinaryIndex binaryIndex) throws Exception {
        if (binary.getDataId() <= 0) {
            long newId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, String.valueOf(this.tableName) + ".id");
            binary.setDataId((int)newId);
        }
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binary.getDataId());
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        SqlContext sqlContext2 = dtsSession.getSqlContext();
        try {
            boolean existTable = sqlContext2.existTable(dtsSession2.getConnection(), binaryGeneration.tableName);
            if (!existTable) {
                this.createTable(dtsSession2, binaryGeneration.tableName);
            }
            this.getPersistenceProxy().putEntitys_3(dtsSession2, binaryGeneration.tableName, binary);
            if (is != null) {
                String whereClause = "id = " + binary.getDataId();
                sqlContext2.putBinary(dtsSession2.getConnection(), binaryGeneration.tableName, this.binaryColumnName, whereClause, is, (int)length);
                is.close();
            }
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                dtsSession2.commit();
            }
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        binaryIndex.setDataId(binary.getDataId());
        if (this.binaryIndexDAO != null) {
            this.binaryIndexDAO.putEntity(dtsSession, binaryIndex);
        }
    }

    public void putBinary(DtsSession dtsSession, ArcvBinary binary, File file, ArcvBinaryIndex binaryIndex) throws Exception {
        if (file != null) {
            ArcvUtil.setFileInfo(binaryIndex, file);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            this.putBinary(dtsSession, binary, is, file.length(), binaryIndex);
            binaryIndex.binaryLength = file.length();
            binaryIndex.binaryType = 1;
            binaryIndex.binaryName = file.getName();
            binaryIndex.fileExtention = BcFileUtil.getExtention(file);
        } else {
            this.putBinary(dtsSession, binary, null, 0L, binaryIndex);
        }
    }

    public int deleteById(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        int cnt = 0;
        try {
            ArcvBinary binary = new ArcvBinary();
            binary.setDataId((int)binaryId);
            cnt = this.getPersistenceProxy().deleteEntity(dtsSession2, binaryGeneration.tableName, binary);
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                dtsSession2.commit();
            }
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        ArcvBinaryIndex binaryIndex = new ArcvBinaryIndex();
        binaryIndex.setDataId((int)binaryId);
        if (this.binaryIndexDAO != null) {
            this.binaryIndexDAO.deleteEntity(dtsSession, binaryIndex);
        }
        return cnt;
    }

    protected ArcvBinary getById(DtsSession dtsSession, String tableName, long binaryId) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + tableName + " WHERE id = " + binaryId;
        return (ArcvBinary)this.getEntity(dtsSession, query);
    }

    public ArcvBinary getById(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        ArcvBinary binary = null;
        try {
            binary = this.getById(dtsSession2, binaryGeneration.tableName, binaryId);
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        return binary;
    }

    public boolean outputById(DtsSession dtsSession, long binaryId, OutputStream os) throws Exception {
        ArcvBinaryHelper binaryHelper = null;
        try {
            binaryHelper = this.createBinaryHelper(dtsSession, binaryId);
            if (binaryHelper == null) {
                return false;
            }
            BcStreamUtil.transmit(binaryHelper.is, os, false, this.bufSize);
        }
        finally {
            if (binaryHelper != null) {
                try {
                    binaryHelper.rs.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
                try {
                    binaryHelper.stmt.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        return true;
    }

    protected ArcvBinaryHelper createBinaryHelper(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        String query = "SELECT " + this.getBinaryColumnName() + " FROM " + this.tableName + " WHERE id = " + binaryId;
        return ArcvServerUtil.createBinaryHelper(dtsSession2.getConnection(), query);
    }

    public void createTable(DtsSession dtsSession, String tableName) throws Exception {
        String primaryKeyName = String.valueOf(tableName) + "__k01";
        String query = "CREATE TABLE " + tableName + " ( id BIGINT" + ",binary_data BYTEA" + " ,CONSTRAINT " + primaryKeyName + " PRIMARY KEY (id)" + ")";
        this.getLogger().info("query=" + query);
        SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }
}

