/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.rmi.client;

import java.io.ObjectInputStream;
import java.net.Socket;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.lib.rmi.client.RmiAgentNet;
import jp.co.extreme.lib.rmi.client.RmiAgentNetThread;
import jp.co.extreme.rmi.connector.RmiObjectStreamConnector;
import jp.co.extreme.rmi.model.RmiNetConfig;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.rmo.ScfHandleRMO;

class RmiAgentNetThread_v100
extends BcLoggableObject {
    RmiAgentNetThread rmiAgentNetThread;
    Socket socket;
    RmiAgentNet rmiAgentNet;
    RmiNetConfig rmiNetConfig;

    public RmiAgentNetThread_v100(RmiAgentNetThread rmiAgentNetThread, Socket socket) throws Exception {
        this.rmiAgentNetThread = rmiAgentNetThread;
        this.socket = socket;
        this.rmiAgentNet = rmiAgentNetThread.rmiAgentNet;
        this.rmiNetConfig = rmiAgentNetThread.rmiNetConfig;
    }

    protected void doConnectL2() throws Exception {
        ObjectInputStream objis = new ObjectInputStream(this.socket.getInputStream());
        int command = (Integer)objis.readObject();
        if (command != 1) {
            if (command == 71) {
                String redirectUrl = (String)objis.readObject();
                this.getLogger().debug("redirectUrl=" + redirectUrl);
                BcAddressPort remoteHostAddressPort = this.rmiNetConfig.currentRemoteHostAddressPort;
                BcAddressPort tmpAddressPort = BcNetUtil.parseAddressPort(redirectUrl);
                remoteHostAddressPort.address = tmpAddressPort.address;
                remoteHostAddressPort.port = tmpAddressPort.port;
                this.socket.close();
                throw new Exception("redirectUrl=" + redirectUrl);
            }
            if (command == 2) {
                String reason = (String)objis.readObject();
                throw new Exception(reason);
            }
            throw new Exception("command=" + command);
        }
        RmiObjectStreamConnector objectStreamConnector = new RmiObjectStreamConnector();
        objectStreamConnector.setNetConfig(this.rmiNetConfig);
        objectStreamConnector.setConnectionEventListener(this.rmiAgentNet);
        objectStreamConnector.setDataRecieveEventHandler(this.rmiAgentNet);
        objectStreamConnector.setSocket(this.socket);
        this.rmiAgentNet.connector = objectStreamConnector;
        this.checkFirstStatus();
    }

    protected boolean checkFirstStatus() throws Exception {
        this.getLogger().info("\u521d\u671f\u30b9\u30c6\u30a4\u30bf\u30b9\u3092\u78ba\u8a8d\u4e2d\u3067\u3059...");
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfHandleRMO.class.getName());
        rmiReq.setMethodName("checkFirstStatus");
        rmiReq.addData(ApApplication.getInstance().getRuntimeContext());
        rmiReq.addData(this.rmiAgentNet.domainCode);
        rmiReq.addData(this.rmiAgentNet.password);
        RmiRespons rmiRes = this.rmiAgentNet.invoke(rmiReq);
        if (rmiRes.getStatusId() == 1) {
            this.getLogger().info("rmiRes.getStatus()=" + rmiRes.getStatusId());
        } else if (rmiRes.getStatusId() == 2) {
            this.getLogger().info("connection max over!");
        }
        this.rmiAgentNet.setRemoteAgentId(rmiRes.getDataAsInteger());
        this.getLogger().info("rmiRemoteAgentId=" + this.rmiAgentNet.getRemoteAgentId());
        return true;
    }
}

