/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.http.client.HtclContentLoader;
import jp.co.extreme.lib.ant.AntUrlTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntDownloadTask
extends Task {
    protected File destDir;
    protected URL baseUrl;
    protected List<Task> taskList = new ArrayList<Task>();
    static String[] sizeUnits = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    @Override
    public void execute() throws BuildException {
        int i = 0;
        while (i < this.taskList.size()) {
            Task task = this.taskList.get(i);
            if (task instanceof AntUrlTask) {
                AntUrlTask urlTask = (AntUrlTask)task;
                try {
                    this.download(urlTask.text);
                }
                catch (Exception ex) {
                    throw new BuildException(ex);
                }
            }
            ++i;
        }
    }

    public void setDir(String dirPath) throws Exception {
        this.destDir = new File(ApApplication.getInstance().toReal(dirPath));
        BcFileUtil.mkdirs(this.destDir, new FileAttribute[0]);
    }

    public Object createUrl() throws Exception {
        AntUrlTask urlTask = new AntUrlTask();
        this.taskList.add(urlTask);
        return urlTask;
    }

    public void download(String relativUrl) throws Exception {
        URL absoluteUrl = new URL(this.baseUrl, relativUrl);
        this.log(absoluteUrl.toString());
        File tmpFile1 = new File(absoluteUrl.getFile());
        File tmpFile2 = File.createTempFile(tmpFile1.getName(), ".tmp", this.destDir);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile2));){
            InnerStreamTransmitter streamTransmitter = new InnerStreamTransmitter();
            HtclContentLoader contentLoader = new HtclContentLoader();
            contentLoader.setStreamTransmitter(streamTransmitter);
            contentLoader.getContent(absoluteUrl, os, -1L, -1L);
        }
        File destFile = new File(this.destDir, tmpFile1.getName());
        BcFileUtil.deleteIfExists(destFile);
        BcFileUtil.rename(tmpFile2, destFile);
    }

    public static String calculateProperFileSize(double zise) throws Exception {
        String str = "";
        int index = 0;
        index = 0;
        while (index < sizeUnits.length) {
            if (zise < 1024.0) break;
            zise /= 1024.0;
            ++index;
        }
        str = String.valueOf(BcNumberUtil.toString(zise, 2)) + " " + sizeUnits[index];
        return str;
    }

    class InnerStreamTransmitter
    extends BcStreamTransmitter {
        InnerStreamTransmitter() {
        }

        @Override
        protected void transferd(long value) throws Exception {
            if (value % 1000L * 10L == 0L) {
                String msg = AntDownloadTask.calculateProperFileSize(value);
                AntDownloadTask.this.log(msg);
            }
        }
    }
}

