/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.http.HttpConstants;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;

public class HttpUtil {
    private HttpUtil() {
    }

    public static String getHeaderValue(HttpResponse httpResponse, String key) {
        Header[] headers = httpResponse.getHeaders(key);
        String value = null;
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            value = header.getValue();
            ++n2;
        }
        return value;
    }

    public static void setCachInvalid(HttpServletResponse httpRes) {
        httpRes.setHeader("Cache-Control", "no-cache");
        httpRes.setHeader("Pragma", "no-cache");
    }

    public static String getUrlBase(HttpServletRequest httpReq) {
        StringBuffer requestUrl = httpReq.getRequestURL();
        int uriIndex = requestUrl.indexOf(httpReq.getRequestURI());
        return requestUrl.substring(0, uriIndex);
    }

    public static String getUrlContextPath(HttpServletRequest httpReq) {
        StringBuilder sb = new StringBuilder(HttpUtil.getUrlBase(httpReq));
        BcStringUtil.append(sb, httpReq.getContextPath());
        return sb.toString();
    }

    public static List<BcPair> createRequestInfoList(HttpServletRequest httpReq) {
        ArrayList<BcPair> pairList = new ArrayList<BcPair>();
        pairList.add(new BcPair<String, StringBuffer>("httpReq.getRequestURL()", httpReq.getRequestURL()));
        pairList.add(new BcPair<String, String>("httpReq.getRequestURI()", httpReq.getRequestURI()));
        pairList.add(new BcPair<String, String>("httpReq.getContentType()", httpReq.getContentType()));
        pairList.add(new BcPair<String, String>("httpReq.getContextPath()", httpReq.getContextPath()));
        pairList.add(new BcPair<String, String>("httpReq.getMethod()", httpReq.getMethod()));
        pairList.add(new BcPair<String, String>("httpReq.getPathInfo()", httpReq.getPathInfo()));
        pairList.add(new BcPair<String, String>("httpReq.getPathTranslated()", httpReq.getPathTranslated()));
        pairList.add(new BcPair<String, String>("httpReq.getProtocol()", httpReq.getProtocol()));
        pairList.add(new BcPair<String, String>("httpReq.getQueryString()", httpReq.getQueryString()));
        pairList.add(new BcPair<String, String>("httpReq.getRemoteAddr()", httpReq.getRemoteAddr()));
        pairList.add(new BcPair<String, String>("httpReq.getRemoteHost()", httpReq.getRemoteHost()));
        pairList.add(new BcPair<String, String>("httpReq.getRemoteUser()", httpReq.getRemoteUser()));
        pairList.add(new BcPair<String, String>("httpReq.getRequestedSessionId()", httpReq.getRequestedSessionId()));
        pairList.add(new BcPair<String, String>("httpReq.getScheme()", httpReq.getScheme()));
        pairList.add(new BcPair<String, String>("httpReq.getServerName()", httpReq.getServerName()));
        pairList.add(new BcPair<String, Integer>("httpReq.getServerPort()", httpReq.getServerPort()));
        pairList.add(new BcPair<String, String>("httpReq.getServletPath()", httpReq.getServletPath()));
        pairList.add(new BcPair<String, String>("httpReq.getAuthType()", httpReq.getAuthType()));
        pairList.add(new BcPair<String, Integer>("httpReq.getContentLength()", httpReq.getContentLength()));
        pairList.add(new BcPair<String, String>("httpReq.getCharacterEncoding()", httpReq.getCharacterEncoding()));
        pairList.add(new BcPair<String, String>("header:User-Agent", httpReq.getHeader(HttpConstants.RequestHeader.User_Agent.value)));
        pairList.add(new BcPair<String, Map>("httpReq.getParameterMap()", httpReq.getParameterMap()));
        ArrayList parameterNameList = Collections.list(httpReq.getParameterNames());
        pairList.add(new BcPair("httpReq.getParameterNames()", parameterNameList));
        return pairList;
    }

    public static StringBuilder createRequestInfo(HttpServletRequest httpReq) {
        List<BcPair> pairList = HttpUtil.createRequestInfoList(httpReq);
        StringBuilder sb = HttpUtil.toInfoString(pairList);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("---- ParameterMap");
        sb.append(BcStringUtil.lineSeparator);
        sb.append((CharSequence)HttpUtil.toInfoString(httpReq.getParameterMap().entrySet()));
        return sb;
    }

    public static StringBuilder toInfoString(Collection<? extends Map.Entry> mapEntryCollection) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (Map.Entry entry : mapEntryCollection) {
            if (++cnt > 1) {
                sb.append(BcStringUtil.lineSeparator);
            }
            sb.append(entry.getKey() + " = " + entry.getValue());
        }
        return sb;
    }

    public static StringBuilder createHeaderLog(HttpServletRequest httpReq) {
        StringBuilder sb = new StringBuilder();
        Enumeration headerNames = httpReq.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration headervals = httpReq.getHeaders(name);
            while (headervals.hasMoreElements()) {
                String val = (String)headervals.nextElement();
                sb.append(name);
                sb.append("=");
                sb.append(val);
                sb.append("\n");
            }
        }
        return sb;
    }

    public static StringBuilder createHeaderLog(HttpServletResponse httpRes) {
        StringBuilder sb = new StringBuilder();
        Collection headerNames = httpRes.getHeaderNames();
        for (String name : headerNames) {
            sb.append(name);
            sb.append("=");
            sb.append(httpRes.getHeader(name));
            sb.append("\n");
        }
        return sb;
    }
}

