/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.viewer;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.viewer.FxxContent;
import jp.co.extreme.fx.viewer.FxxContentGroup;
import jp.co.extreme.fx.viewer.FxxImageLoadTask;
import jp.co.extreme.fx.viewer.FxxUrlEvent;

public class FxxNavigatePane
extends FxBorderPane {
    FlowPane tilePane = new FlowPane();
    ScrollPane scrollPane = new ScrollPane();
    public static double scale = 0.1;
    EventHandler<? super FxxUrlEvent> eventHandler;

    public FxxNavigatePane() throws Exception {
        this.tilePane.setPadding(new Insets(8.0));
        this.tilePane.setVgap(8.0);
        this.tilePane.setHgap(8.0);
        this.tilePane.setOrientation(Orientation.VERTICAL);
        this.tilePane.setPrefHeight(2000.0);
        this.scrollPane.setContent((Node)this.tilePane);
        this.setCenter((Node)this.scrollPane);
    }

    protected void setEventHandler(EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    public void setContents(FxxContentGroup contentGroup) throws Exception {
        this.tilePane.getChildren().clear();
        ArrayList<FxxContent> contentList = new ArrayList<FxxContent>();
        int i = 0;
        while (i < contentGroup.getContentCount()) {
            FxxContent content = contentGroup.getContentNode(i);
            contentList.add(content);
            ++i;
        }
        FxxImageLoadTask imageLoadTask = new FxxImageLoadTask(contentList, (Pane)this.tilePane, this.eventHandler);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(imageLoadTask);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }
}

