/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.table;

import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javax.swing.table.TableModel;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableViewEvent;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.SwgUtil;

public class FxTableView<T>
extends TableView
implements FxTableViewEvent {
    protected EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent ev) {
            try {
                FxTableView.this.keyEvent(ev);
            }
            catch (Exception ex) {
                FxTableView.this.handleException(ex);
            }
        }
    };
    protected EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent ev) {
            try {
                FxTableView.this.mouseEventHandle(ev);
            }
            catch (Exception ex) {
                FxTableView.this.handleException(ex);
            }
        }
    };
    protected ChangeListener<Boolean> focuseChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            try {
                if (newValue.booleanValue()) {
                    FxTableView.this.focusIn();
                } else {
                    FxTableView.this.focusOut();
                }
            }
            catch (Exception ex) {
                FxTableView.this.handleException(ex);
            }
        }
    };
    private Pane headerPane;
    private TableModel attributeTable;
    public double headerHeight = FxTableUtil.calcHeaderHeight(2);

    public FxTableView() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        this.setPlaceholder((Node)new Label(""));
        TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.setOnKeyPressed(this.keyEventHandler);
        this.setOnMouseClicked(this.mouseEventHandler);
        this.focusedProperty().addListener(this.focuseChangeListener);
        selectionModel.selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number prevRowIndex, Number nextRowIndex) {
                try {
                    ObservableList rowIdList = FxTableView.this.getSelectionModel().getSelectedIndices();
                    FxTableView.this.rowSelectionChanged(FxTableView.this, rowIdList, prevRowIndex.intValue(), nextRowIndex.intValue());
                }
                catch (Exception ex) {
                    FxTableView.this.handleException(ex);
                }
            }
        });
        selectionModel.selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> value, Object previous, Object next) {
            }
        });
        selectionModel.selectedItemProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable value) {
            }
        });
        this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ev) {
                Dragboard dragboard = FxTableView.this.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                ClipboardContent clipboardContent = new ClipboardContent();
                dragboard.setContent((Map)clipboardContent);
                ev.consume();
            }
        });
        this.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                ev.consume();
            }
        });
        this.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
            }
        });
        this.setOnMouseDragEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ev) {
            }
        });
        this.getColumns().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                change.next();
                try {
                    FxTableView.this.columnChanged(change);
                }
                catch (Exception ex) {
                    FxTableView.this.handleException(ex);
                }
            }
        });
        this.skinProperty().addListener((ChangeListener)new ChangeListener<Skin>(){

            public void changed(ObservableValue<? extends Skin> value, Skin previous, Skin next) {
                try {
                    FxTableView.this.skinChanged(previous, next);
                }
                catch (Exception ex) {
                    FxTableView.this.handleException(ex);
                }
            }
        });
    }

    public Pane getHeaderPane() throws Exception {
        if (this.headerPane == null) {
            this.headerPane = (Pane)this.lookup("TableHeaderRow");
        }
        return this.headerPane;
    }

    public TableModel getAttributeTable() {
        return this.attributeTable;
    }

    public void setAttributeTable(TableModel attributeTable) {
        this.attributeTable = attributeTable;
    }

    protected void mouseEventHandle(MouseEvent ev) throws Exception {
        boolean doubleClicked = FxUtil.isDoubleClicked(ev);
        TableView.TableViewSelectionModel tableViewSelectionModel = this.getSelectionModel();
        ObservableList tablePositionList = tableViewSelectionModel.getSelectedCells();
        this.rowSelected(this, tablePositionList, ev, doubleClicked);
    }

    protected void keyEvent(KeyEvent ev) throws Exception {
    }

    protected void focusIn() throws Exception {
    }

    protected void focusOut() throws Exception {
    }

    protected void columnChanged(ListChangeListener.Change change) throws Exception {
    }

    protected void skinChanged(Skin preSkin, Skin newSkin) throws Exception {
        this.getHeaderPane().setPrefHeight(this.getHeaderHeight());
    }

    protected double getHeaderHeight() throws Exception {
        return this.headerHeight;
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

