/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.skin;

import java.io.InputStream;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcURLStreamHandler;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.skin.FxSkinDefault;
import jp.co.extreme.fx.skin.FxSkinUtil;
import jp.co.extreme.fx.util.FxColorUtil;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.swing.SwgTableViewUtil;

public class FxSkinBlack
extends FxSkinDefault {
    @Override
    public Color getBaseColor1() throws Exception {
        return Color.BLACK;
    }

    @Override
    public Color getBaseDarkColor() throws Exception {
        return Color.web((String)"#0A0A0A");
    }

    @Override
    public Color getBaseBrightColor() throws Exception {
        return Color.web((String)"#333333");
    }

    @Override
    public void setStyle(Node node) throws Exception {
        if (node instanceof Pane) {
            Pane pane = (Pane)node;
            String style1 = FxCssUtil.css_backgroundColor_linearGradient(this.getBaseDarkColor(), this.getBaseBrightColor(), 4);
            FxCssUtil.addProperty(node, style1);
            this.setStyle((Collection<? extends Node>)pane.getChildren());
            if (node instanceof FxFlowPane) {
                FxFlowPane flowPane = (FxFlowPane)node;
                this.setStyle_NodeUnit(flowPane.nodeUnitList);
            }
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            String style1 = FxCssUtil.css_backgroundColor(this.getBaseDarkColor());
            FxCssUtil.addProperty(node, style1);
            this.setStyle(scrollPane.getContent());
        } else if (node instanceof SplitPane) {
            SplitPane splitPane = (SplitPane)node;
            String style1 = FxCssUtil.css_backgroundColor(this.getBaseDarkColor());
            FxCssUtil.addProperty(node, style1);
            this.setStyle((Collection<? extends Node>)splitPane.getItems());
        } else if (node instanceof TabPane) {
            TabPane tabPane = (TabPane)node;
            String style1 = FxCssUtil.css_backgroundColor(this.getBaseDarkColor());
            FxCssUtil.addProperty(node, style1);
            ObservableList tabList = tabPane.getTabs();
            int i = 0;
            while (i < tabList.size()) {
                Tab tab = (Tab)tabList.get(i);
                this.setStyle(tab.getContent());
                ++i;
            }
        } else if (node instanceof Labeled) {
            if (node instanceof ButtonBase) {
                if (!(node instanceof CheckBox)) {
                    ButtonBase buttonBase = (ButtonBase)node;
                    buttonBase.setEffect((Effect)FxEffectUtil.createDropShadowForButton());
                }
            } else if (node instanceof TitledPane) {
                TitledPane titledPane = (TitledPane)node;
                titledPane.getContent();
            }
        } else if (node instanceof TextField) {
            TextField textField = (TextField)node;
            FxCssUtil.setStyle_form_01((TextInputControl)textField);
        } else if (node instanceof TextArea) {
            TextArea textArea = (TextArea)node;
            FxCssUtil.setStyle_form_01((TextInputControl)textArea);
        } else if (node instanceof PasswordField) {
            PasswordField passwordField = (PasswordField)node;
            FxCssUtil.setStyle_form_01((TextInputControl)passwordField);
        } else if (node instanceof ComboBox) {
            ComboBox comboBox = (ComboBox)node;
        }
    }

    @Override
    public void setStyle(Collection<? extends Node> nodeCollection) throws Exception {
        for (Node node : nodeCollection) {
            this.setStyle(node);
        }
    }

    @Override
    public void setStyle(FxNodeUnit nodeUnit) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            this.setStyle(leftNode);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            this.setStyle(rightNode);
            ++i;
        }
    }

    @Override
    public void setStyle_NodeUnit(Collection<? extends FxNodeUnit> nodeUnitCollection) throws Exception {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            this.setStyle(fxNodeUnit);
        }
    }

    @Override
    protected StringBuilder convCss(byte[] bytes) throws Exception {
        StringBuilder css = new StringBuilder(new String(bytes));
        css = BcStringUtil.replace((CharSequence)css, "${baseBg}", FxCssUtil.toRgba(this.getBaseColor1()));
        css = BcStringUtil.replace((CharSequence)css, "${baseBgDark}", FxCssUtil.toRgba(this.getBaseDarkColor()));
        css = BcStringUtil.replace((CharSequence)css, "${baseBgBright}", FxCssUtil.toRgba(this.getBaseBrightColor()));
        Font defaultFont = FxFontUtil.getDefaultFont();
        css = BcStringUtil.replace((CharSequence)css, "${fontSize1}", "9pt");
        css = BcStringUtil.replace((CharSequence)css, "${fontFamily1}", FxFontUtil.defaultFontName);
        css = BcStringUtil.replace((CharSequence)css, "${fontName1}", FxFontUtil.defaultFontName);
        css = BcStringUtil.replace((CharSequence)css, "${fontWeight1}", FxFontUtil.defaultFontWeight.name());
        css = BcStringUtil.replace((CharSequence)css, "${labelFg}", FxCssUtil.toRgba(Color.WHITE));
        css = BcStringUtil.replace((CharSequence)css, "${textFieldBg}", FxCssUtil.toRgba(Color.BLACK));
        css = BcStringUtil.replace((CharSequence)css, "${textFieldFg}", FxCssUtil.toRgba(Color.AQUA));
        css = BcStringUtil.replace((CharSequence)css, "${textFieldReadonlyBg}", FxCssUtil.toRgba(Color.CORAL));
        css = BcStringUtil.replace((CharSequence)css, "${textFieldEffect}", FxCssUtil.createInnershadow());
        css = BcStringUtil.replace((CharSequence)css, "${buttonBg}", "linear-gradient(#AAAAAA, #999999)");
        css = this.conv_table(css);
        return css;
    }

    @Override
    protected StringBuilder conv_table(StringBuilder css) throws Exception {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Object value = uiDefaults.get("Panel.background");
        if (value == null) {
            value = java.awt.Color.BLACK;
        }
        java.awt.Color panelbackgroundColor = (java.awt.Color)value;
        Color tableGridColor = FxSkinUtil.getColorByKey("Table.gridColor");
        css = BcStringUtil.replace((CharSequence)css, "${tableGridColor}", FxCssUtil.toRgba(tableGridColor));
        css = BcStringUtil.replace((CharSequence)css, "${tableHeaderBg}", FxCssUtil.toRgba(this.getBaseBrightColor()));
        Color tmpColor = FxSkinUtil.getColorByKey("TableHeader.foreground");
        css = BcStringUtil.replace((CharSequence)css, "${tableHeaderFg}", FxCssUtil.toRgba(tmpColor));
        tmpColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowOddBg(panelbackgroundColor));
        css = BcStringUtil.replace((CharSequence)css, "${tableRowOddBg}", FxCssUtil.toRgba(tmpColor));
        tmpColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowEvenBg(panelbackgroundColor));
        css = BcStringUtil.replace((CharSequence)css, "${tableRowEvenBg}", FxCssUtil.toRgba(tmpColor));
        tmpColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowSelectedBg(panelbackgroundColor));
        tmpColor = Color.web((String)"#003856");
        css = BcStringUtil.replace((CharSequence)css, "${tableRowSelectedBg}", FxCssUtil.toRgba(tmpColor));
        tmpColor = FxColorUtil.convFromAwt(SwgTableViewUtil.toRowSelectedFg(panelbackgroundColor));
        tmpColor = Color.web((String)"#53A8A6");
        css = BcStringUtil.replace((CharSequence)css, "${tableRowSelectedFg}", FxCssUtil.toRgba(tmpColor));
        return css;
    }

    @Override
    public void setCss(Scene scene) throws Exception {
        String dir = null;
        if (!BcRuntimeUtil.isJava_1_8()) {
            throw new Exception("Not Supported Java Version.");
        }
        dir = "css_v1_8";
        this.setCss(scene, dir, "base.css");
        this.setCss(scene, dir, "tableView.css");
        this.setCss(scene, dir, "treeView.css");
        this.setCss(scene, dir, "tab.css");
        this.setCss(scene, dir, "contextMenu.css");
    }

    @Override
    protected void setCss(Scene scene, String dir, String fileName) throws Exception {
        String url = "internal:" + fileName;
        String path = String.valueOf(dir) + "/" + fileName;
        InputStream is = FxSkinBlack.class.getResourceAsStream(path);
        byte[] bytes = BcStreamUtil.readWithClose(is);
        if (bytes == null) {
            BcLogUtil.debug("bytes is null. path=" + path);
            return;
        }
        StringBuilder css = this.convCss(bytes);
        BcURLStreamHandler.getInstance().map.put(fileName, css.toString().getBytes());
        scene.getStylesheets().add((Object)url);
    }
}

