/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.etc.model.EtcInputText;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;

public class FxxCheckBoxGroupControl
extends FxBorderPane
implements EtcInputText {
    protected FxFlowPane flowPane = new FxFlowPane();
    protected List<CheckBox> checkBoxList = new ArrayList<CheckBox>();

    public FxxCheckBoxGroupControl(int arrangement) throws Exception {
        this.flowPane.setArrangement(arrangement);
        this.flowPane.topMargin = 4.0;
        this.flowPane.bottomMargin = 6.0;
        this.flowPane.leftMargin = 6.0;
        this.flowPane.leftRightSpace = 0.0;
        this.flowPane.rightNodeSpace = 0.0;
        this.flowPane.rowSpace = 0.0;
        this.setCenter((Node)this.flowPane);
    }

    @Override
    public String getInputText() throws Exception {
        ArrayList<String> keyList = new ArrayList<String>();
        int i = 0;
        while (i < this.checkBoxList.size()) {
            CheckBox checkBox = this.checkBoxList.get(i);
            if (checkBox.isSelected()) {
                String key = (String)checkBox.getUserData();
                keyList.add(key);
            }
            ++i;
        }
        return BcStringUtil.toCsv(keyList).toString();
    }

    @Override
    public void setInputText(String strValue) throws Exception {
        List<String> keyList = BcStringUtil.stringTokenize(strValue, BcStringUtil.COMMA_STR, false, true);
        block0: for (CheckBox checkBox : this.checkBoxList) {
            checkBox.setSelected(false);
            for (String key : keyList) {
                if (!checkBox.getUserData().equals(key)) continue;
                checkBox.setSelected(true);
                continue block0;
            }
        }
    }

    public void setData(Collection<Map.Entry<String, String>> mapEntryCollection, Map<String, String> tooltipMap) throws Exception {
        this.checkBoxList.clear();
        for (Map.Entry<String, String> mapEntry : mapEntryCollection) {
            String tooltipStr;
            FxCheckBox checkBox = new FxCheckBox(mapEntry.getValue());
            if (tooltipMap != null && !BcStringUtil.isEmpty(tooltipStr = tooltipMap.get(mapEntry.getKey()))) {
                Tooltip tooltip = new Tooltip(tooltipStr);
                checkBox.setTooltip(tooltip);
            }
            this.checkBoxList.add(checkBox);
            checkBox.setUserData(mapEntry.getKey());
            FxNodeUnit nodeUnit = new FxNodeUnit((Node)checkBox, new Node[0]);
            this.flowPane.addNodeUnit(nodeUnit);
        }
    }

    public void setData(Collection<Map.Entry<String, String>> mapEntryCollection) throws Exception {
        this.setData(mapEntryCollection, null);
    }

    public void setData(String[] keys, String[] texts) throws Exception {
        ArrayList<Map.Entry<String, String>> mapEntryList = new ArrayList<Map.Entry<String, String>>();
        int i = 0;
        while (i < keys.length) {
            AbstractMap.SimpleEntry<String, String> mapEntry = new AbstractMap.SimpleEntry<String, String>(keys[i], texts[i]);
            mapEntryList.add(mapEntry);
            ++i;
        }
        this.setData(mapEntryList);
    }

    public void setValue(FxxCheckBoxGroupControl checkBoxControl) throws Exception {
        this.setInputText(checkBoxControl.getInputText());
    }
}

