/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.print.attribute.standard.MediaSize;
import jp.co.extreme.base.core.BcDouble;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.util.BcConditionElement;
import jp.co.extreme.doc.script.DcfScriptParser;
import jp.co.extreme.doc.util.DcfConstants;
import jp.co.extreme.doc.util.DcfDocumentEventListener;
import jp.co.extreme.doc.util.DcfPageReader;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfRectangleShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;

public final class DcfDocumentUtil {
    public static final double inch72Retio = 1.0266948;
    public static final double MARGIN = 20.0;
    protected static HashMap renderingHintMap4Image;
    protected static HashMap renderingHintMap4Print;
    static DcfScriptParser docScriptParser;

    static {
        docScriptParser = new DcfScriptParser();
    }

    private DcfDocumentUtil() {
    }

    public static double transformRatio(double value, double ratio) throws Exception {
        double res = value / (100.0 / ratio);
        return res;
    }

    public static double mmToInch(double mm) {
        return mm / (double)25.4f;
    }

    public static double mmToPixel(double mm) {
        double inch = DcfDocumentUtil.mmToInch(mm);
        return inch * 72.0;
    }

    public static double mmToPixel_deprecated1(double mm) {
        return 2.65 * mm;
    }

    public static double mmToPixel_deprecated2(double mm) {
        return mm * 2.849;
    }

    public static double inch72ToPixel(double inch72) {
        return inch72 / 1.0266948;
    }

    public static double pixelToInch72(double pixcel) {
        return 1.0266948 * pixcel;
    }

    public static String decode(String src) {
        StringBuilder sb = BcStringUtil.replace((CharSequence)src, BcStringUtil.HORIZONTAL_TAB_STR, BcStringUtil.fill(' ', DcfConstants.tabLength));
        return sb.toString();
    }

    public static boolean isLineSeparator(char aCHar) {
        return aCHar == '\r' || aCHar == '\n';
    }

    public static void changeRectangleRatio(DcfRectangleShape rectangleShape1, double ratio, DcfRectangleShape rectangleShape2) throws Exception {
        rectangleShape2.setX(DcfDocumentUtil.transformRatio(rectangleShape1.getX(), ratio));
        rectangleShape2.setY(DcfDocumentUtil.transformRatio(rectangleShape1.getY(), ratio));
        rectangleShape2.getRectangle().width = DcfDocumentUtil.transformRatio(rectangleShape1.getRectangle().width, ratio);
        rectangleShape2.getRectangle().height = DcfDocumentUtil.transformRatio(rectangleShape1.getRectangle().height, ratio);
    }

    public static HashMap getRenderingHintMap4Image() throws Exception {
        if (renderingHintMap4Image == null) {
            renderingHintMap4Image = new HashMap();
        }
        return renderingHintMap4Image;
    }

    public static HashMap getRenderingHintMap4Print() throws Exception {
        if (renderingHintMap4Print == null) {
            renderingHintMap4Print = new HashMap();
        }
        renderingHintMap4Print.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return renderingHintMap4Print;
    }

    public static void createRectangleShape(DcfShapeGroup shapeGroup, double x1, double y1, double x2, double y2, double lineWidth) throws Exception {
        DcfLineShape lineShape = new DcfLineShape("", x1, y1, x2, y1);
        lineShape.lineWidth = lineWidth;
        shapeGroup.addShape(lineShape);
        lineShape = new DcfLineShape("", x1, y1, x1, y2);
        lineShape.lineWidth = lineWidth;
        shapeGroup.addShape(lineShape);
        lineShape = new DcfLineShape("", x2, y1, x2, y2);
        lineShape.lineWidth = lineWidth;
        shapeGroup.addShape(lineShape);
        lineShape = new DcfLineShape("", x1, y2, x2, y2);
        lineShape.lineWidth = lineWidth;
        shapeGroup.addShape(lineShape);
    }

    public static int calcRowCount(Font font, FontRenderContext fontRenderContext, double eWidth, double eHeight, List<String> strList, int strListOffset, BcDouble rectHeight) {
        double fontHeight = DcfDocumentUtil.calcFontHeight(font, fontRenderContext);
        if (rectHeight == null) {
            rectHeight = new BcDouble();
        }
        rectHeight.value = 0.0;
        int rowCount = 0;
        String str = null;
        int len = 0;
        TextLayout layout = null;
        int i = 0;
        while (i < strList.size() - strListOffset) {
            str = strList.get(strListOffset + i);
            len = str.length();
            if (len <= 0) {
                rectHeight.value += fontHeight;
                if (eHeight >= 0.0 && rectHeight.value >= eHeight) break;
                ++rowCount;
            } else {
                AttributedString attStr = new AttributedString(str);
                attStr.addAttribute(TextAttribute.FONT, font, 0, len);
                AttributedCharacterIterator iter = attStr.getIterator();
                LineBreakMeasurer lbreak = new LineBreakMeasurer(iter, fontRenderContext);
                lbreak.setPosition(0);
                while (lbreak.getPosition() < len) {
                    layout = lbreak.nextLayout((int)eWidth);
                    if (eHeight >= 0.0 && rectHeight.value >= eHeight) break;
                    ++rowCount;
                    rectHeight.value += fontHeight;
                }
            }
            ++i;
        }
        return rowCount;
    }

    public static int calcRowCount(Font font, FontRenderContext fontRenderContext, double eWidth, String sourceStr) throws Exception {
        String str = DcfDocumentUtil.decode(sourceStr).toString();
        ArrayList<String> strList = new ArrayList<String>();
        BcStringUtil.lineSeparetor(str, strList);
        int rowCount = DcfDocumentUtil.calcRowCount(font, fontRenderContext, eWidth, -1.0, strList, 0, null);
        return rowCount;
    }

    public static double calcHeight(Font font, FontRenderContext fontRenderContext, double eWidth, String sourceStr) throws Exception {
        fontRenderContext = DcfDocumentUtil.createDefaultFontRenderContext(fontRenderContext);
        double height = DcfDocumentUtil.calcFontHeight(font, fontRenderContext) * (double)DcfDocumentUtil.calcRowCount(font, fontRenderContext, eWidth, sourceStr);
        return height;
    }

    public static double calcFontHeight(Font font, FontRenderContext fontRenderContext) {
        fontRenderContext = DcfDocumentUtil.createDefaultFontRenderContext(fontRenderContext);
        TextLayout textLayout = DcfDocumentUtil.createDefaultTextLayout(font, null);
        double fontHeight = textLayout.getAscent() + textLayout.getDescent();
        return fontHeight;
    }

    public static TextLayout createDefaultTextLayout(Font font, FontRenderContext fontRenderContext) {
        fontRenderContext = DcfDocumentUtil.createDefaultFontRenderContext(fontRenderContext);
        TextLayout textLayout = new TextLayout("A\u6f22", font, fontRenderContext);
        return textLayout;
    }

    public static FontRenderContext createDefaultFontRenderContext(FontRenderContext fontRenderContext) {
        if (fontRenderContext == null) {
            fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        }
        return fontRenderContext;
    }

    public static FontRenderContext createDefaultFontRenderContext() {
        return DcfDocumentUtil.createDefaultFontRenderContext(null);
    }

    public static void addShape(DcfDocumentEventListener docEventListener, DcfShapeGroup shapeGroup, BcDouble yOffset, boolean doseAddYOffset, DcfTextShape baseTextShape) throws Exception {
        if (BcStringUtil.isEmpty(baseTextShape.value)) {
            return;
        }
        baseTextShape.value = DcfDocumentUtil.decode(baseTextShape.value).toString();
        ArrayList<String> strList = new ArrayList<String>();
        BcStringUtil.lineSeparetor(baseTextShape.value, strList);
        if (strList.size() == 0) {
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        BcDouble rectHeight = new BcDouble();
        StringBuilder sb = new StringBuilder(1024);
        BcDouble tmpYOffset = new BcDouble(yOffset.value);
        int strListOffset = 0;
        while (strListOffset < strList.size()) {
            int tmpStrCount = DcfDocumentUtil.calcRowCount(baseTextShape.font, fontRenderContext, baseTextShape.getRectangle().width, shapeGroup.getRectangle().height - tmpYOffset.value, strList, strListOffset, rectHeight);
            if (tmpStrCount <= 0) {
                shapeGroup = docEventListener.getNewShapeGroup(shapeGroup, tmpYOffset);
                continue;
            }
            DcfTextShape rectangleShape = (DcfTextShape)baseTextShape.clone();
            rectangleShape.setY(tmpYOffset.value + rectangleShape.getY());
            rectangleShape.getRectangle().height = rectHeight.value;
            sb.delete(0, sb.length());
            int i = 0;
            while (i < tmpStrCount) {
                if (strListOffset + i >= strList.size()) break;
                sb.append((String)strList.get(strListOffset + i));
                sb.append("\n");
                ++i;
            }
            rectangleShape.value = sb.toString();
            shapeGroup.addShape(rectangleShape);
            strListOffset += tmpStrCount;
            tmpYOffset.value += rectangleShape.getRectangle().height;
        }
        if (doseAddYOffset) {
            yOffset.value = tmpYOffset.value;
        }
    }

    public static double getMaxWidth(DcfPageReader pageReader) throws Exception {
        double maxWidth = 0.0;
        int i = 0;
        while (i < pageReader.getPageCount()) {
            DcfPage dcfPage = pageReader.getPage(i);
            DcfPageFormat pageFormat = dcfPage.getPageFormat();
            maxWidth = Math.max(maxWidth, pageFormat.getWidth());
            ++i;
        }
        return maxWidth;
    }

    public static double getHeightSum(DcfPageReader pageReader) throws Exception {
        double height = 0.0;
        int i = 0;
        while (i < pageReader.getPageCount()) {
            DcfPage dcfPage = pageReader.getPage(i);
            DcfPageFormat pageFormat = dcfPage.getPageFormat();
            height += pageFormat.getHeight();
            ++i;
        }
        return height;
    }

    public static DcfPage createStandardPage() throws Exception {
        DcfPage dcfPage = new DcfPage();
        DcfShapeGroup shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("ph");
        shapeGroup.setLabel("Page Header");
        shapeGroup.setMovable(false);
        dcfPage.addGroup(shapeGroup);
        return dcfPage;
    }

    public static DcfPage createReportPage() throws Exception {
        DcfPage dcfPage = new DcfPage();
        dcfPage.setPaperSize(MediaSize.ISO.A4, 1);
        DcfShapeGroup shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("rh");
        shapeGroup.setLabel("\u30ec\u30dd\u30fc\u30c8\u30d8\u30c3\u30c0");
        shapeGroup.setMovable(false);
        dcfPage.addGroup(shapeGroup);
        shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("ph");
        shapeGroup.setLabel("\u30da\u30fc\u30b8\u30d8\u30c3\u30c0");
        dcfPage.addGroup(shapeGroup);
        shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("pc");
        shapeGroup.setLabel("\u8a73\u7d30");
        dcfPage.addGroup(shapeGroup);
        shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("pf");
        shapeGroup.setLabel("\u30da\u30fc\u30b8\u30d5\u30c3\u30bf");
        dcfPage.addGroup(shapeGroup);
        shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("rf");
        shapeGroup.setLabel("\u30ec\u30dd\u30fc\u30c8\u30d5\u30c3\u30bf");
        dcfPage.addGroup(shapeGroup);
        shapeGroup = new DcfShapeGroup();
        shapeGroup.setName("rfd");
        shapeGroup.setLabel("");
        dcfPage.addGroup(shapeGroup);
        return dcfPage;
    }

    public static DcfPage loadPage(Class clazz, String path) throws Exception {
        DcfPage dcfPage;
        try (InputStream is = clazz.getResourceAsStream(path);){
            dcfPage = docScriptParser.toPage(is);
        }
        return dcfPage;
    }

    public static DcfPage loadPage(Object object, String path) throws Exception {
        return DcfDocumentUtil.loadPage(object.getClass(), path);
    }

    public static void setStandardHeader(DcfShapeGroup shapeGroup, double yOffset, String title, String subTitle, List<BcConditionElement> conditionList) throws Exception {
        DcfTextShape textShape = null;
        int fontSize = 8;
        boolean isBorder = false;
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(0.0, yOffset + 30.0, 230.0, 24.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 3, 14);
        textShape.value = title;
        shapeGroup.addShape(textShape);
        if (subTitle != null) {
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(4.0, yOffset + 54.0, 230.0, 20.0);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 3, 12);
            textShape.value = subTitle;
            shapeGroup.addShape(textShape);
        }
        if (conditionList == null) {
            return;
        }
        int rowMax = 4;
        int rowCount = 0;
        double nX = 240.0;
        double nW = 64.0;
        double sX = nX + nW;
        double sW = 8.0;
        double vX = nX + nW + sW;
        double vW = 120.0;
        double y = yOffset + 30.0;
        double h = 12.0;
        double vGap = 0.0;
        double hGap = 4.0;
        if (conditionList == null) {
            return;
        }
        BcConditionElement condition = null;
        int i = 0;
        while (i < conditionList.size()) {
            if (rowCount >= rowMax) {
                y = yOffset + 30.0;
                nX += nW + vW + sW + hGap;
                sX += nW + vW + sW + hGap;
                vX += nW + vW + sW + hGap;
                rowCount = 0;
            }
            ++rowCount;
            condition = conditionList.get(i);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(nX, y, nW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 2, fontSize);
            textShape.horizontalAlign = 4;
            textShape.value = condition.name;
            shapeGroup.addShape(textShape);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(sX, y, sW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
            textShape.value = ":";
            shapeGroup.addShape(textShape);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(vX, y, vW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
            textShape.value = condition.value;
            shapeGroup.addShape(textShape);
            y += h + vGap;
            ++i;
        }
    }

    public static void setTrialElement(DcfShapeGroup shapeGroup) throws Exception {
        DcfTextShape textShape = new DcfTextShape();
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, 100);
        textShape.setX(0.0);
        textShape.setY(0.0);
        textShape.getRectangle().width = shapeGroup.getWidth();
        textShape.getRectangle().height = shapeGroup.getHeight();
        textShape.setLine(false);
        textShape.horizontalAlign = 0;
        textShape.horizontalAlign = 0;
        textShape.textColor = new Color(230, 230, 230);
        textShape.value = "\u8a55\u4fa1\u7248";
        shapeGroup.addShape(textShape);
    }

    public static void textReplace(DcfPage dcfPage, CharSequence str1, CharSequence str2) throws Exception {
        int i = 0;
        while (i < dcfPage.getGroupCount()) {
            DcfShapeGroup shapeGroup = dcfPage.getGroup(i);
            int j = 0;
            while (j < shapeGroup.getShapeCount()) {
                DcfShape rectangleShape = shapeGroup.getShape(j);
                if (DcfTextShape.class.isAssignableFrom(rectangleShape.getClass())) {
                    DcfTextShape textShape = (DcfTextShape)rectangleShape;
                    textShape.value = BcStringUtil.replace((CharSequence)textShape.value, str1, str2).toString();
                }
                ++j;
            }
            ++i;
        }
    }

    public static DcfPage createTestOverlayPage(String printText) throws Exception {
        if (BcStringUtil.isEmpty(printText)) {
            printText = "TEST";
        }
        DcfPage dcfPage = DcfDocumentUtil.createStandardPage();
        DcfShapeGroup shapeGroup = dcfPage.getGroup("ph");
        float topMargin = 50.0f;
        float leftMargin = 50.0f;
        float width = 80.0f;
        float height = 30.0f;
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 2) {
                float x = leftMargin + (float)i * width;
                float y = topMargin + (float)j * height;
                DcfTextShape textShape = new DcfTextShape();
                textShape.value = printText;
                textShape.font = new Font("SansSerif", 2, 5);
                textShape.horizontalAlign = 2;
                textShape.lineColor = new Color(230, 230, 230);
                textShape.setRect(x, y, width, height);
                shapeGroup.addShape(textShape);
                ++j;
            }
            ++i;
        }
        return dcfPage;
    }

    public static void storeBook(DcfBook dcfBook, File destFile) throws Exception {
        BcFileUtil.makeParent(destFile);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(destFile));){
            objectOutputStream.writeObject(dcfBook);
        }
    }
}

