/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.barcode.renderer;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Dimension;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import jp.co.extreme.awt.AwtImageObserver;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.doc.barcode.renderer.DcfAbstractBarcodeRenderer;

public class DcfZxingRenderer
extends DcfAbstractBarcodeRenderer {
    private int width;
    private int height;
    private boolean doFit;
    private int angle;
    private DataMatrixWriter dataMatrixWriter = new DataMatrixWriter();
    private BufferedImage bufferedImage;
    private String barcodeValue;
    private AwtImageObserver imageObserver = new AwtImageObserver();

    public DcfZxingRenderer(int width, int height, boolean doFit, int angle) {
        this.width = width;
        this.height = height;
        this.doFit = doFit;
        this.angle = angle;
    }

    @Override
    public double[] getSize(String value) throws Exception {
        this.createImage(value);
        double[] dim = new double[]{this.bufferedImage.getWidth(), this.bufferedImage.getHeight()};
        return dim;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String barcodeValue) throws Exception {
        this.createImage(barcodeValue);
        g2d.drawImage(this.bufferedImage, (int)bx, (int)by, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), this.imageObserver);
    }

    protected synchronized void createImage(String barcodeValue) throws Exception {
        if (BcStringUtil.equals(this.getBarcodeValue(), barcodeValue) && this.bufferedImage != null) {
            return;
        }
        EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        if (this.width == this.height) {
            hintMap.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.FORCE_SQUARE);
        } else {
            hintMap.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.FORCE_RECTANGLE);
        }
        hintMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        hintMap.put(EncodeHintType.MARGIN, (Object)0);
        if (this.doFit) {
            hintMap.put(EncodeHintType.MIN_SIZE, (Object)new Dimension(this.width, this.height));
        }
        BitMatrix bitMatrix = this.dataMatrixWriter.encode(barcodeValue, BarcodeFormat.DATA_MATRIX, this.width, this.height, hintMap);
        MatrixToImageConfig matrixToImageConfig = new MatrixToImageConfig(-16777216, -1);
        this.bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig);
        if (this.angle > 0) {
            this.bufferedImage = AwtImageUtil.rotate(this.bufferedImage, this.angle);
        }
        this.setBarcodeValue(barcodeValue);
    }

    public String getBarcodeValue() {
        return this.barcodeValue;
    }

    public void setBarcodeValue(String barcodeValue) {
        this.barcodeValue = barcodeValue;
    }
}

