/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.util.DtsWordManager;

public class DtsWordManagerImpl
implements DtsWordManager {
    public Map<String, Map<String, String>> wordMap = new HashMap<String, Map<String, String>>();
    public List<String> langCodeList = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws Exception {
        Map<String, Map<String, String>> map = this.wordMap;
        synchronized (map) {
            this.wordMap.clear();
            this.langCodeList.clear();
        }
    }

    @Override
    public void putWord(String wordCode, String langCode, String wordValue) {
        Map<String, String> langMap = this.wordMap.get(wordCode);
        if (langMap == null) {
            langMap = new HashMap<String, String>();
            this.wordMap.put(wordCode, langMap);
        }
        langMap.put(langCode, wordValue);
    }

    @Override
    public String getWord(String wordCode, String langCode) {
        String wordValue = this.getWord_L2(wordCode, langCode);
        if (!BcStringUtil.isEmpty(wordValue)) {
            return wordValue;
        }
        int i = 0;
        while (i < this.langCodeList.size()) {
            Map<String, String> langMap;
            String langCode2 = this.langCodeList.get(i);
            if (!langCode2.equals(langCode) && (langMap = this.wordMap.get(wordCode)) != null && !BcStringUtil.isEmpty(wordValue = langMap.get(langCode2))) break;
            ++i;
        }
        return wordValue;
    }

    public String getWord_L2(String wordCode, String langCode) {
        Map<String, String> langMap = this.wordMap.get(wordCode);
        if (langMap == null) {
            return null;
        }
        return langMap.get(langCode);
    }

    public StringBuilder listWords() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> mapEntry : this.wordMap.entrySet()) {
            String wordCode = mapEntry.getKey();
            Map<String, String> langMap = mapEntry.getValue();
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("--- wordCode=" + wordCode);
            for (Map.Entry<String, String> mapEntry2 : langMap.entrySet()) {
                String langCode = mapEntry2.getKey();
                String wordValue = mapEntry2.getValue();
                sb.append("\n" + langCode + "=" + wordValue);
            }
        }
        return sb;
    }
}

