/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.context.SqlContextFactory;

public class DtsConnectionManagerImpl
extends DtsConnectionManager {
    private ConcurrentLinkedQueue<SqlConnection> idlingQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<SqlConnection> lendingQueue = new ConcurrentLinkedQueue();
    private ValidationTask validationTask;
    private Timer validationTaskTimer;

    @Override
    public void setup(Driver driver, String jdbcUrl, Properties dataSourceProperties) throws Exception {
        if (this.getJdbcUrl() != null) {
            String msg = String.format("Setup is complete. JDBC-URL=%s", this.getJdbcUrl());
            throw new Exception(msg);
        }
        this.getLogger().info(String.format("Setting up... JDBC-URL=%s", jdbcUrl));
        this.setDriver(driver);
        if (driver != null) {
            dataSourceProperties.setProperty(SqlConstants.DataSourceProperty.driver.name(), driver.getClass().getName());
        }
        this.setJdbcUrl(jdbcUrl);
        dataSourceProperties.setProperty(SqlConstants.DataSourceProperty.url.name(), jdbcUrl);
        this.setDataSourceProperties(dataSourceProperties);
        this.getLogger().debug("user=" + dataSourceProperties.getProperty(SqlConstants.DataSourceProperty.user.name()));
        this.getLogger().debug("validationInterval=" + BcTimeUtil.toDurationString2(this.getValidationInterval()));
        this.getLogger().debug("validationDelay=" + BcTimeUtil.toDurationString2(this.getValidationDelay()));
        this.getLogger().debug("minIdle=" + this.getMinIdle());
        this.getLogger().debug("maxIdle=" + this.getMaxIdle());
        this.getLogger().debug("maxConnection=" + this.getMaxConnection());
        this.getLogger().debug("maxUsage=" + this.getMaxUsage());
        this.getLogger().debug("queryTimeout=" + BcTimeUtil.toDurationString2(this.getQueryTimeout()));
        this.getLogger().debug("lendingTimeout=" + BcTimeUtil.toDurationString2(this.getLendingTimeout()));
        this.getLogger().debug("queryTimeoutForScroll=" + BcTimeUtil.toDurationString2(this.getQueryTimeoutForScroll()));
        this.getLogger().debug("lendingTimeoutForScroll=" + BcTimeUtil.toDurationString2(this.getLendingTimeoutForScroll()));
        this.validationTask = new ValidationTask();
        this.validationTaskTimer = new Timer();
        this.validationTaskTimer.schedule((TimerTask)this.validationTask, this.getValidationDelay(), this.getValidationInterval());
    }

    @Override
    public SqlContext getSqlContext(Connection sqlConn) throws Exception {
        SqlContext sqlContext = super.getSqlContext(sqlConn);
        if (sqlContext == null) {
            if (sqlConn == null) {
                sqlConn = SqlUtil.connect(this.getDriver(), this.getJdbcUrl(), this.getDataSourceProperties());
                sqlContext = SqlContextFactory.getSqlContext(sqlConn);
                sqlConn.close();
            } else {
                sqlContext = SqlContextFactory.getSqlContext(sqlConn);
            }
            sqlContext.setLogger(this.getLogger());
            this.setSqlContext(sqlContext);
        }
        return sqlContext;
    }

    @Override
    public SqlConnection getConnection() throws Exception {
        SqlConnection sqlConn = null;
        sqlConn = this.idlingQueue.poll();
        if (sqlConn != null) {
            if (sqlConn.isClosed()) {
                throw new Exception("Connection status not valid.");
            }
            boolean isValid = sqlConn.isValid(this.getSqlContext(sqlConn).getValidationTimeout());
            if (!isValid) {
                this.getLogger().warning("Connection is not valid.");
            }
        }
        if (sqlConn == null) {
            sqlConn = this.createConnection();
        }
        sqlConn.setQueryTimeout(this.getQueryTimeout());
        sqlConn.setLendingStartTime(System.currentTimeMillis());
        sqlConn.setLendingTimeout(this.getLendingTimeout());
        sqlConn.setLendingTimeoutTime(null);
        ++sqlConn.usage;
        this.lendingQueue.offer(sqlConn);
        return sqlConn;
    }

    @Override
    public void returnConnection(SqlConnection sqlConn) throws Exception {
        if (this.lendingQueue.remove(sqlConn)) {
            boolean isReuse = true;
            if (sqlConn.maxUsage > 0 && sqlConn.usage >= sqlConn.maxUsage) {
                isReuse = false;
            }
            if (this.getMaxIdle() > 0 && this.idlingQueue.size() >= this.getMaxIdle()) {
                isReuse = false;
            }
            if (isReuse) {
                this.initConnection(sqlConn);
                this.idlingQueue.offer(sqlConn);
            } else {
                try {
                    sqlConn.rollback();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
                sqlConn.desturuct();
            }
        } else {
            throw new Exception("returnConnection:E1001");
        }
    }

    protected void initConnection(SqlConnection sqlConn) throws Exception {
        sqlConn.rollback();
        SqlStatement[] sqlStatements = sqlConn.statementList.toArray(new SqlStatement[sqlConn.statementList.size()]);
        int i = 0;
        while (i < sqlStatements.length) {
            SqlStatement sqlStatement = sqlStatements[i];
            if (!sqlStatement.isClosed()) {
                try {
                    sqlStatement.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
            ++i;
        }
        sqlConn.init();
    }

    protected SqlConnection createConnection() throws Exception {
        if (this.getMaxConnection() > 0 && this.getConnectionCount() > this.getMaxConnection()) {
            String msg = "Datasource connection max over. getConnectionCount()=" + this.getConnectionCount();
            throw new Exception(msg);
        }
        Connection sqlConnTmp = SqlUtil.connect(this.getDriver(), this.getJdbcUrl(), this.getDataSourceProperties());
        SqlContext sqlContext = this.getSqlContext(sqlConnTmp);
        SqlConnection sqlConn = new SqlConnection(sqlConnTmp, sqlContext, this);
        sqlConn.setLogger(this.getLogger());
        sqlConn.setCreateTime(System.currentTimeMillis());
        sqlContext.setTransactionIsolation(sqlConn);
        sqlConn.setAutoCommit(false);
        sqlConn.maxUsage = this.getMaxUsage();
        sqlConn.setQueryTimeout(this.getQueryTimeout());
        sqlConn.setLongQueryTime(this.getLongQueryTime());
        return sqlConn;
    }

    @Override
    public int getConnectionCount() throws Exception {
        int count = 0;
        count += this.idlingQueue.size();
        return count += this.lendingQueue.size();
    }

    @Override
    public void destruct() throws Exception {
        SqlConnection sqlConn;
        this.getLogger().info("Destructing... JDBC-URL=" + this.getJdbcUrl());
        this.setDriver(null);
        this.setDataSourceProperties(null);
        try {
            this.validationTaskTimer.cancel();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        this.validationTaskTimer = null;
        this.validationTask = null;
        while (this.idlingQueue.size() > 0) {
            sqlConn = this.idlingQueue.poll();
            try {
                sqlConn.rollback();
                sqlConn.desturuct();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        this.idlingQueue = null;
        while (this.lendingQueue.size() > 0) {
            sqlConn = this.lendingQueue.poll();
            try {
                sqlConn.rollback();
                sqlConn.desturuct();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        this.lendingQueue = null;
        this.getLogger().info("Destructed. JDBC-URL=" + this.getJdbcUrl());
    }

    public Queue<SqlConnection> getIdlingQueue() {
        return this.idlingQueue;
    }

    public Queue<SqlConnection> getLendingQueue() {
        return this.lendingQueue;
    }

    public synchronized void validation(boolean doRemove, BcLogger logger) throws Exception {
        StringBuilder sb = new StringBuilder();
        logger.debug("---- validation");
        logger.debug("idlingQueue.size=" + this.idlingQueue.size());
        SqlConnection[] sqlConArray = this.lendingQueue.toArray(new SqlConnection[0]);
        logger.debug("lendingQueue.size=" + sqlConArray.length);
        int i = 0;
        while (i < sqlConArray.length) {
            SqlConnection sqlConn = sqlConArray[i];
            try {
                String suffix1 = "sqlCon[1/" + sqlConArray.length + "]:";
                this.validation_L2(sqlConn, doRemove, suffix1, logger);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
        logger.debug("");
        while (this.idlingQueue.size() < this.getMinIdle()) {
            SqlConnection sqlConn = this.createConnection();
            this.idlingQueue.offer(sqlConn);
            logger.debug("add:hashCode=" + sqlConn.hashCode() + " idlingQueue.size=" + this.idlingQueue.size());
        }
    }

    protected synchronized void validation_L2(SqlConnection sqlConn, boolean doRemove, String suffix1, BcLogger logger) throws Exception {
        logger.debug(String.valueOf(suffix1) + "hashCode()=" + sqlConn.hashCode());
        String suffix2 = BcStringUtil.fill(' ', 2);
        logger.debug(String.valueOf(suffix2) + "createTime=" + BcTimeUtil.toString(sqlConn.getCreateTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
        logger.debug(String.valueOf(suffix2) + "isClosed=" + sqlConn.isClosed());
        logger.debug(String.valueOf(suffix2) + "lendingStartTime=" + BcTimeUtil.toString(sqlConn.getLendingStartTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
        logger.debug(String.valueOf(suffix2) + "lendingTimeout=" + BcTimeUtil.toDurationString2(sqlConn.getLendingTimeout()));
        long lendingSpan = -1L;
        if (sqlConn.getLendingTimeout() > 0L) {
            lendingSpan = System.currentTimeMillis() - sqlConn.getLendingStartTime();
            logger.debug(String.valueOf(suffix2) + "lendingSpan=" + BcTimeUtil.toDurationString2(lendingSpan));
        }
        if (sqlConn.getLendingTimeoutTime() != null) {
            logger.debug(String.valueOf(suffix2) + "lendingTimeoutTime=" + BcTimeUtil.toString(sqlConn.getLendingTimeoutTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
        }
        logger.debug(String.valueOf(suffix2) + "owner=" + sqlConn.getOwner());
        logger.debug(String.valueOf(suffix2) + "usage=" + sqlConn.usage);
        SqlStatement[] sqlStatements = sqlConn.statementList.toArray(new SqlStatement[sqlConn.statementList.size()]);
        logger.debug("  statements.length=" + sqlStatements.length);
        int i = 0;
        while (i < sqlStatements.length) {
            SqlStatement sqlStatement = sqlStatements[i];
            try {
                String suffix3 = "    statement[" + (i + 1) + "/" + sqlStatements.length + "]";
                this.validation_L3(sqlStatement, suffix3, logger);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
        logger.debug("");
        if (!doRemove) {
            return;
        }
        if (sqlConn.getLendingTimeout() > 0L && lendingSpan >= sqlConn.getLendingTimeout()) {
            logger.debug("  lending timeout:sqlConn.hashCode=" + sqlConn.hashCode());
            try {
                sqlConn.rollback();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            try {
                sqlConn.close();
                sqlConn.setLendingTimeoutTime(System.currentTimeMillis());
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            this.getLendingQueue().remove(sqlConn);
            logger.debug("  removed:sqlConn.hashCode=" + sqlConn.hashCode());
        }
    }

    protected synchronized void validation_L3(SqlStatement sqlStatement, String suffix, BcLogger logger) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(suffix);
        sb.append(":createTime=" + BcTimeUtil.toString(sqlStatement.getCreateTime(), "yyyy/MM/dd HH:mm:ss.SSS") + ": isClosed=" + sqlStatement.isClosed());
        if (sqlStatement.getCloseTime() != null) {
            sb.append(" closeTime=" + BcTimeUtil.toString(sqlStatement.getCloseTime(), "yyyyMMddHHmmssSSS"));
        }
        sb.append(" queryTimeout=" + BcTimeUtil.toDurationString2(sqlStatement.getQueryTimeout()));
        logger.debug(sb);
        SqlContext sqlContext = this.getSqlContext(null);
        if (!sqlContext.isSupported(SqlContext.Function.queryTimeout) && sqlStatement.getQueryStartTime() != null) {
            long queryStartTime = sqlStatement.getQueryStartTime();
            if (sqlStatement.getQueryTimeout() > 0) {
                long querySpan = System.currentTimeMillis() - queryStartTime;
                logger.debug("    querySpan=" + BcTimeUtil.toDurationString2(querySpan));
                if (querySpan >= (long)(sqlStatement.getQueryTimeout() * 1000)) {
                    logger.debug("Statement canceling...");
                    sqlStatement.cancel();
                    logger.debug("Statement canceled.");
                }
            }
        }
        logger.debug("  query=\n" + sqlStatement.getQuery());
    }

    class ValidationTask
    extends TimerTask {
        ValidationTask() {
        }

        @Override
        public void run() {
            try {
                DtsConnectionManagerImpl.this.validation(true, DtsConnectionManagerImpl.this.getLogger());
            }
            catch (Exception ex) {
                DtsConnectionManagerImpl.this.getLogger().error(ex);
            }
        }
    }
}

