/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileFilter;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public final class BcZipUtil {
    public static final String EXTENTION_zip = "zip";
    public static final String EXTENTION_dot_zip = String.valueOf(BcStringUtil.DOT_STR) + "zip";

    private BcZipUtil() {
    }

    public static List<ZipEntry> createEntryList(ZipFile zipFile) throws Exception {
        ArrayList<ZipEntry> zipEntryList = new ArrayList<ZipEntry>();
        Enumeration<ZipEntry> entryEnum = zipFile.getEntries();
        while (entryEnum.hasMoreElements()) {
            ZipEntry zipEntry = entryEnum.nextElement();
            zipEntryList.add(zipEntry);
        }
        return zipEntryList;
    }

    public static byte[] getAsByteArray(ZipFile zipFile, String entryName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(entryName);
        byte[] bytes = new byte[(int)zipEntry.getSize()];
        Throwable throwable = null;
        Object var5_7 = null;
        try (BufferedInputStream zipIs = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int off = 0;
            int len = 0;
            while ((len = ((InputStream)zipIs).read(bytes, off, bytes.length - off)) != -1 && bytes.length > off) {
                off += len;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bytes;
    }

    public static String getFileName(String entryName) {
        int pos = -1;
        char aChar = '\u0000';
        int i = 0;
        while (i < entryName.length()) {
            pos = entryName.length() - (i + 1);
            aChar = entryName.charAt(pos);
            if (aChar == '/') {
                return entryName.substring(pos + 1, entryName.length());
            }
            ++i;
        }
        return entryName;
    }

    public static boolean isZipFile(String fileName) throws Exception {
        String extention = BcFileUtil.getExtention(fileName);
        return BcStringUtil.equalsIgnoreCase(extention, EXTENTION_zip) || BcStringUtil.equalsIgnoreCase(extention, "jar");
    }

    public static void extract(ZipFile zipFile, ZipEntry zipEntry, OutputStream os) throws Exception {
        Throwable throwable = null;
        Object var4_6 = null;
        try (BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
            streamTransmitter.transmit(is, os);
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void extract(ZipFile zipFile, ZipEntry zipEntry, File destFile, BcStreamTransmitter streamTransmitter) throws Exception {
        BcFileUtil.makeParent(destFile);
        BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));
        try {
            streamTransmitter.transmit(is, os);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }
    }

    public static void compression(File srcFile, BcFileFilter fileFilter, File destFile) throws Exception {
        try (ZipOutputStream zipOs = new ZipOutputStream(new FileOutputStream(destFile));){
            BcZipUtil.compression("", srcFile, fileFilter, zipOs);
        }
    }

    public static void compression(String parentPath, File srcFile, BcFileFilter fileFilter, ZipOutputStream zipOs) throws Exception {
        BcLogUtil.info("toZip:srcFile=" + srcFile.getPath());
        boolean isAccept = true;
        if (fileFilter != null) {
            isAccept = fileFilter.accept(srcFile);
        }
        if (!isAccept) {
            return;
        }
        if (srcFile.isDirectory()) {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(parentPath) + srcFile.getName() + "/");
            zipOs.putNextEntry(zipEntry);
            String[] fileNameList = srcFile.list();
            int i = 0;
            while (i < fileNameList.length) {
                File file = new File(String.valueOf(srcFile.getPath()) + "/" + fileNameList[i]);
                BcZipUtil.compression(String.valueOf(parentPath) + srcFile.getName() + "/", file, fileFilter, zipOs);
                ++i;
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(parentPath) + srcFile.getName());
            zipOs.putNextEntry(zipEntry);
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFile));){
                BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
                streamTransmitter.transmit(is, zipOs);
            }
        }
    }

    public static void zipEntryLog(ZipFile zipFile, BcLogger logger) throws Exception {
        List<ZipEntry> zipEntryList = BcZipUtil.createEntryList(zipFile);
        int i = 0;
        while (i < zipEntryList.size()) {
            ZipEntry zipEntry = zipEntryList.get(i);
            logger.info("zipEntry.getName()=" + zipEntry.getName());
            logger.info("zipEntry.getSize()=" + zipEntry.getSize());
            ++i;
        }
    }
}

