/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLoggableObject;

public class BcObjectConvertor
extends BcLoggableObject {
    public static BcObjectConvertor getInstance() {
        return SingletonHolder.instance;
    }

    public Object numberToObject(Number srcValue, Class dstClass, String formatPattern, Locale locale) throws Exception {
        if (srcValue == null) {
            if (dstClass.isPrimitive()) {
                Class wrapperClass = BcLangUtil.toWrapperClass(dstClass);
                return BcLangUtil.getDefaultValue(wrapperClass);
            }
            return null;
        }
        Object dstValue = null;
        if (srcValue.getClass().equals(dstClass)) {
            dstValue = srcValue;
        }
        if (dstClass.equals(Long.class) || dstClass.equals(Long.TYPE)) {
            dstValue = srcValue.longValue();
        } else if (dstClass.equals(Integer.class) || dstClass.equals(Integer.TYPE)) {
            dstValue = srcValue.intValue();
        } else if (dstClass.equals(Short.class) || dstClass.equals(Short.TYPE)) {
            dstValue = srcValue.shortValue();
        } else if (dstClass.equals(Byte.class) || dstClass.equals(Byte.TYPE)) {
            dstValue = srcValue.byteValue();
        } else if (dstClass.equals(Double.class) || dstClass.equals(Double.TYPE)) {
            dstValue = srcValue.doubleValue();
        } else if (dstClass.equals(Float.class) || dstClass.equals(Float.TYPE)) {
            dstValue = Float.valueOf(srcValue.floatValue());
        } else if (BigDecimal.class.isAssignableFrom(dstClass)) {
            dstValue = new BigDecimal(srcValue.toString());
        } else if (String.class.isAssignableFrom(dstClass)) {
            formatPattern = null;
            if (formatPattern != null) {
                DecimalFormat decimalFormat = new DecimalFormat(formatPattern);
                return decimalFormat.format(srcValue);
            }
            if (locale != null) {
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                dstValue = numberFormat.format(srcValue);
            } else {
                dstValue = srcValue.toString();
            }
        } else if (dstClass.equals(Boolean.class) || dstClass.equals(Boolean.TYPE)) {
            dstValue = BcBooleanUtil.toBoolean(srcValue.intValue());
        } else if (dstClass.equals(Object.class)) {
            this.getLogger().warning("number.class=" + srcValue.getClass().getName());
            dstValue = srcValue;
        } else {
            throw new Exception("Can not convert." + srcValue.getClass().getName() + " -> " + dstClass.getName());
        }
        return dstValue;
    }

    public Object stringToObject(String srcValue, Class dstClass, String formatPattern, Locale locale) throws Exception {
        if (BcStringUtil.isEmpty(srcValue)) {
            if (dstClass.isPrimitive()) {
                Class wrapperClass = BcLangUtil.toWrapperClass(dstClass);
                return BcLangUtil.getDefaultValue(wrapperClass);
            }
            return null;
        }
        Object dstValue = null;
        if (dstClass.equals(Integer.class) || dstClass.equals(Integer.TYPE)) {
            dstValue = new Integer(srcValue);
        } else if (dstClass.equals(Short.class) || dstClass.equals(Short.TYPE)) {
            dstValue = new Short(srcValue);
        } else if (dstClass.equals(Long.class) || dstClass.equals(Long.TYPE)) {
            dstValue = new Long(srcValue);
        } else if (dstClass.equals(Character.class) || dstClass.equals(Character.TYPE)) {
            dstValue = new Character(srcValue.charAt(0));
        } else if (dstClass.equals(Byte.class) || dstClass.equals(Byte.TYPE)) {
            dstValue = new Byte(srcValue);
        } else if (dstClass.equals(Float.class) || dstClass.equals(Float.TYPE)) {
            dstValue = new Float(srcValue);
        } else if (dstClass.equals(Double.class) || dstClass.equals(Double.TYPE)) {
            dstValue = new Double(srcValue);
        } else if (dstClass.equals(BigDecimal.class)) {
            dstValue = new BigDecimal(srcValue);
        } else if (dstClass.equals(Boolean.TYPE)) {
            dstValue = new Boolean(srcValue);
        } else if (dstClass.equals(String.class)) {
            dstValue = srcValue.toString();
        } else if (dstClass.equals(StringBuilder.class)) {
            dstValue = new StringBuilder(srcValue);
        } else if (dstClass.equals(StringBuffer.class)) {
            dstValue = new StringBuffer(srcValue);
        } else if (Enum.class.isAssignableFrom(dstClass)) {
            dstValue = BcLangUtil.getEnumByName(dstClass, srcValue);
        } else if (dstClass.equals(Calendar.class)) {
            if (!BcStringUtil.isEmpty(srcValue)) {
                dstValue = BcTimeUtil.toCalendar(srcValue, formatPattern);
            }
        } else if (dstClass.equals(java.util.Date.class)) {
            if (!BcStringUtil.isEmpty(srcValue)) {
                Calendar calendar = BcTimeUtil.toCalendar(srcValue, formatPattern);
                dstValue = new java.util.Date(calendar.getTimeInMillis());
            }
        } else if (dstClass.equals(Timestamp.class)) {
            if (!BcStringUtil.isEmpty(srcValue)) {
                Calendar calendar = BcTimeUtil.toCalendar(srcValue, formatPattern);
                dstValue = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (dstClass.equals(Date.class)) {
            if (!BcStringUtil.isEmpty(srcValue)) {
                Calendar calendar = BcTimeUtil.toCalendar(srcValue, formatPattern);
                dstValue = new Date(calendar.getTimeInMillis());
            }
        } else if (dstClass.equals(Time.class)) {
            if (!BcStringUtil.isEmpty(srcValue)) {
                Calendar calendar = BcTimeUtil.toCalendar(srcValue, formatPattern);
                dstValue = new Time(calendar.getTimeInMillis());
            }
        } else {
            throw new Exception(String.valueOf(String.class.getName()) + " -> " + dstClass.getName());
        }
        return dstValue;
    }

    public java.util.Date localDateTimeToDate(LocalDateTime localDateTime) throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
        Instant instant = zonedDateTime.toInstant();
        java.util.Date date = java.util.Date.from(instant);
        return date;
    }

    public Calendar localDateTimeToCalendar(LocalDateTime localDateTime) throws Exception {
        java.util.Date date = this.localDateTimeToDate(localDateTime);
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public Object convertCalendar(Calendar calendar, Class dstClass, String formatPattern, Locale locale) throws Exception {
        if (dstClass.equals(Calendar.class)) {
            return calendar;
        }
        if (dstClass.equals(String.class)) {
            return BcTimeUtil.toString(calendar, formatPattern, locale);
        }
        if (dstClass.equals(java.util.Date.class)) {
            return new java.util.Date(calendar.getTimeInMillis());
        }
        throw new Exception(String.valueOf(Calendar.class.getName()) + " -> " + dstClass.getName());
    }

    public Object convert(Object srcValue, Class dstClass, String formatPattern, Locale locale) throws Exception {
        Calendar calendar;
        if (srcValue == null) {
            if (dstClass.isPrimitive()) {
                return BcLangUtil.getDefaultValue(dstClass);
            }
            return null;
        }
        Class<?> srcClass = srcValue.getClass();
        if (srcClass.equals(dstClass)) {
            return srcValue;
        }
        Object newValue = null;
        if (java.util.Date.class.isAssignableFrom(srcClass)) {
            calendar = BcTimeUtil.createCalendar();
            calendar.setTime((java.util.Date)srcValue);
            srcValue = calendar;
            srcClass = srcValue.getClass();
        } else if (LocalDateTime.class.isAssignableFrom(srcClass)) {
            LocalDateTime localDateTime = (LocalDateTime)srcValue;
            Calendar calendar2 = this.localDateTimeToCalendar(localDateTime);
            srcValue = calendar2;
            srcClass = srcValue.getClass();
        }
        if (Boolean.class.isAssignableFrom(srcClass)) {
            newValue = CharSequence.class.isAssignableFrom(dstClass) ? Boolean.toString((Boolean)srcValue) : srcValue;
        } else if (BigDecimal.class.isAssignableFrom(srcClass)) {
            newValue = BigDecimal.class.isAssignableFrom(dstClass) ? srcValue : this.numberToObject((Number)srcValue, dstClass, formatPattern, locale);
        } else if (Number.class.isAssignableFrom(srcClass)) {
            newValue = this.numberToObject((Number)srcValue, dstClass, formatPattern, locale);
        } else if (CharSequence.class.isAssignableFrom(srcClass)) {
            newValue = this.stringToObject(srcValue.toString(), dstClass, formatPattern, locale);
        } else if (Calendar.class.isAssignableFrom(srcClass)) {
            calendar = (Calendar)srcValue;
            newValue = this.convertCalendar(calendar, dstClass, formatPattern, locale);
        } else if (CharSequence.class.isAssignableFrom(dstClass)) {
            newValue = this.stringToObject(srcValue.toString(), dstClass, formatPattern, locale);
        } else {
            throw new Exception(String.valueOf(srcClass.getName()) + " -> " + dstClass.getName());
        }
        return newValue;
    }

    public Object convert(Object srcObj, Class dstClass) throws Exception {
        return this.convert(srcObj, dstClass, null, null);
    }

    private static final class SingletonHolder {
        private static final BcObjectConvertor instance = new BcObjectConvertor();

        private SingletonHolder() {
        }
    }
}

