/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.table;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCsvUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class BcCsvToTable {
    public static BcCsvToTable getInstance() {
        return SingletonHolder.instance;
    }

    public void csvToTable(CSVFormat csvFormat, Reader reader, BcTableModel tableModel, int headerRowNumber) throws Exception {
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        CSVParser csvRecords = csvFormat.parse(reader);
        for (CSVRecord csvRecord : csvRecords) {
            ArrayList<String> tableRow = new ArrayList<String>();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                tableRow.add(value);
                ++i;
            }
            if (csvRecord.getRecordNumber() < (long)headerRowNumber) continue;
            if (csvRecord.getRecordNumber() == (long)headerRowNumber) {
                this.addColumnName(tableColumnModel, tableRow);
                continue;
            }
            int gap = tableRow.size() - tableColumnModel.getColumnCount();
            if (gap > 0) {
                int i2 = 0;
                while (i2 < gap) {
                    MmdField mmdField = this.createMmdField(Integer.toString(tableColumnModel.getColumnCount() + 1));
                    BcTableColumn tableColumn = new BcTableColumn(tableColumnModel.getColumnCount());
                    tableColumn.setMmdField(mmdField);
                    tableColumnModel.addColumn(tableColumn);
                    ++i2;
                }
            }
            tableModel.addRow(tableRow);
        }
    }

    public BcTableModel csvToTable(CSVFormat csvFormat, Reader reader, int headerRowNumber) throws Exception {
        BcTableModel tableModel = new BcTableModel();
        this.csvToTable(csvFormat, reader, tableModel, headerRowNumber);
        return tableModel;
    }

    public BcTableModel csvToTable(Reader reader, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        return this.csvToTable(csvFormat, reader, headerRowNumber);
    }

    public BcTableModel csvToTable(CSVFormat csvFormat, String csv, int headerRowNumber) throws Exception {
        CharArrayReader charArrayReader = new CharArrayReader(csv.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        return this.csvToTable(csvFormat, bufferedReader, headerRowNumber);
    }

    public BcTableModel csvToTable(String csv, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        return this.csvToTable(csvFormat, csv, headerRowNumber);
    }

    public MmdField createMmdField(String columnName) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.columnName = BcStringUtil.toString(columnName);
        return mmdField;
    }

    public BcTableColumn createTableColumn(String columnName) throws Exception {
        MmdField mmdField = this.createMmdField(columnName);
        BcTableColumn tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        return tableColumn;
    }

    public BcTableColumn addColumnName(BcTableColumnModel tableColumnModel, String columnName) throws Exception {
        BcTableColumn tableColumn = this.createTableColumn(columnName);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumn;
    }

    public void addColumnName(BcTableColumnModel tableColumnModel, List<? extends String> columnNameList) throws Exception {
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            this.addColumnName(tableColumnModel, columnName);
            ++i;
        }
    }

    public void addColumnName(BcTableColumnModel tableColumnModel, String ... columnNames) throws Exception {
        List<String> columnNameList = Arrays.asList(columnNames);
        this.addColumnName(tableColumnModel, columnNameList);
    }

    private static final class SingletonHolder {
        private static final BcCsvToTable instance = new BcCsvToTable();

        private SingletonHolder() {
        }
    }
}

