/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLog4jHelper;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerLog4j;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public final class BcLogUtil {
    public static final String ROOT_LOGGER_NAME = "";
    static String layout = "%d{yyyy/MM/dd HH:mm:ss.SSS} %-5p %c{1} - %m%n";
    public static Map<String, BcLogger> loggerMap = new ConcurrentHashMap<String, BcLogger>();
    private static BcLogger loggerDefault;
    public static final BcLogConstants.LogLevel logLevelDefault;
    protected static BcLog4jHelper log4jHelper;

    static {
        logLevelDefault = BcLogConstants.LogLevel.INFO;
        log4jHelper = new BcLog4jHelper();
        try {
            BcLogger logger = BcLogUtil.createLogger(ROOT_LOGGER_NAME, false, logLevelDefault, true, null);
            BcLogUtil.setDefaultLogger(logger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log4jHelper.getLogger(ROOT_LOGGER_NAME).error(ex);
        }
    }

    private BcLogUtil() {
    }

    public static synchronized BcLogger createLogger(String loggerName, boolean isAdditive, BcLogConstants.LogLevel logLevel, boolean consoleEnabled, File destFile) throws Exception {
        Logger log4jLogger;
        BcLoggerLog4j bcLoggerLog4j = (BcLoggerLog4j)loggerMap.get(loggerName);
        if (bcLoggerLog4j == null) {
            bcLoggerLog4j = new BcLoggerLog4j();
            log4jLogger = log4jHelper.getLogger(loggerName);
            bcLoggerLog4j.setLog4jLogger(log4jLogger);
            bcLoggerLog4j.setLog4jHelper(log4jHelper);
        } else {
            log4jLogger = (Logger)bcLoggerLog4j.getLog4jLogger();
        }
        log4jLogger.setAdditive(isAdditive);
        log4jHelper.removeAllAppender(log4jLogger.getName());
        Level log4JLevel = BcLog4jHelper.tolog4JLevel(logLevel);
        log4jHelper.setAllLevels(loggerName, log4JLevel);
        if (consoleEnabled) {
            log4jHelper.addConsoleAppender(log4jLogger, AppenderName.CONSOLE.name(), layout);
        }
        if (destFile != null) {
            System.out.println("destFile=" + destFile.getPath());
            BcFileUtil.writeableCheck(destFile);
            log4jHelper.addFileAppender(log4jLogger, AppenderName.FILE.name(), layout, destFile);
        }
        loggerMap.put(loggerName, bcLoggerLog4j);
        return bcLoggerLog4j;
    }

    public static BcLogger getLogger(String loggerName) {
        BcLogger logger = loggerMap.get(loggerName);
        return logger;
    }

    public static BcLogger getDefaultLogger() {
        return loggerDefault;
    }

    public static void setDefaultLogger(BcLogger logger) {
        loggerDefault = logger;
    }

    public static void fatal(Object log) {
        loggerDefault.fatal(log);
    }

    public static void error(Object log) {
        loggerDefault.error(log);
    }

    public static void warning(Object log) {
        loggerDefault.warning(log);
    }

    public static void info(Object log) {
        loggerDefault.info(log);
    }

    public static void debug(Object log) {
        loggerDefault.debug(log);
    }

    public static void trace(Object log) {
        loggerDefault.trace(log);
    }

    public static String getStackTrace(Throwable throwable) {
        String stackTrace;
        block5: {
            StringWriter sw = null;
            PrintWriter pw = null;
            stackTrace = null;
            try {
                try {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.getBuffer().toString();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    BcStreamUtil.close(sw);
                    BcStreamUtil.close(pw);
                    break block5;
                }
            }
            catch (Throwable throwable2) {
                BcStreamUtil.close(sw);
                BcStreamUtil.close(pw);
                throw throwable2;
            }
            BcStreamUtil.close(sw);
            BcStreamUtil.close(pw);
        }
        return stackTrace;
    }

    public static String convertMessage(Object message) {
        if (message == null) {
            return null;
        }
        String newMessage = null;
        if (Throwable.class.isAssignableFrom(message.getClass())) {
            Throwable throwable = (Throwable)message;
            newMessage = BcLogUtil.getStackTrace(throwable);
        } else {
            newMessage = message.toString();
        }
        return newMessage;
    }

    public static String createLabel(String title, String charStr, int pre, int totalLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fill(charStr, pre));
        sb.append(" ");
        sb.append(title);
        sb.append(" ");
        if (sb.length() < totalLength) {
            sb.append(BcStringUtil.fill(charStr, totalLength - sb.length()));
        }
        return sb.toString();
    }

    public static void setupDefault() {
        File destDir = new File(BcRuntimeUtil.getUserDir(), "log");
        File destFile = new File(destDir, "default.log");
        try {
            BcLogger logger = BcLogUtil.createLogger(ROOT_LOGGER_NAME, false, logLevelDefault, true, destFile);
            BcLogUtil.setDefaultLogger(logger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log4jHelper.getLogger(ROOT_LOGGER_NAME).error(ex);
        }
    }

    public static enum AppenderName {
        CONSOLE,
        FILE;

    }
}

