/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;

public class BcFileFilter
extends BcLoggableObject
implements FileFilter {
    public boolean dirEnable = true;
    public boolean fileEnable = true;
    public boolean hiddenEnable = false;
    protected List<String> acceptPatternList = new ArrayList<String>();
    protected List<String> notAcceptPatternList = new ArrayList<String>();
    public Calendar lastModifiedStart;
    public Calendar lastModifiedEnd;
    public static final String ALL_FILES = ".*";

    @Override
    public boolean accept(File file) {
        String commonPath2;
        String commonPath1;
        String pattern;
        boolean isAccept = false;
        if (file.isFile()) {
            if (!this.isFileEnable()) {
                return isAccept;
            }
        } else if (this.isDirEnable()) {
            isAccept = true;
        } else {
            return isAccept;
        }
        if (file.isHidden() && !this.isHiddenEnable()) {
            return false;
        }
        if (this.lastModifiedStart != null && file.lastModified() <= this.lastModifiedStart.getTimeInMillis()) {
            return false;
        }
        if (this.lastModifiedEnd != null && file.lastModified() >= this.lastModifiedEnd.getTimeInMillis()) {
            return false;
        }
        int i = 0;
        while (i < this.notAcceptPatternList.size()) {
            pattern = this.notAcceptPatternList.get(i);
            if (Pattern.matches(pattern, file.getName())) {
                return false;
            }
            commonPath1 = BcFileUtil.toCommonPath(file.getPath());
            if (commonPath1.endsWith(commonPath2 = BcFileUtil.toCommonPath(pattern))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.acceptPatternList.size()) {
            pattern = this.acceptPatternList.get(i);
            if (Pattern.matches(pattern, file.getName())) {
                return true;
            }
            commonPath1 = BcFileUtil.toCommonPath(file.getPath());
            if (commonPath1.endsWith(commonPath2 = BcFileUtil.toCommonPath(pattern))) {
                return true;
            }
            ++i;
        }
        return isAccept;
    }

    public boolean isDirEnable() {
        return this.dirEnable;
    }

    public void setDirEnable(boolean dirEnable) {
        this.dirEnable = dirEnable;
    }

    public boolean isFileEnable() {
        return this.fileEnable;
    }

    public void setFileEnable(boolean fileEnable) {
        this.fileEnable = fileEnable;
    }

    public boolean isHiddenEnable() {
        return this.hiddenEnable;
    }

    public void setHiddenEnable(boolean hiddenEnable) {
        this.hiddenEnable = hiddenEnable;
    }

    public void addAcceptPattern(String \uff50attern) {
        if (!this.acceptPatternList.contains(\uff50attern)) {
            this.acceptPatternList.add(\uff50attern);
        }
    }

    public void addNotAcceptPattern(String fileName) {
        if (!this.notAcceptPatternList.contains(fileName)) {
            this.notAcceptPatternList.add(fileName);
        }
    }
}

