/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.core.BcTimeUtil_JP;
import jp.co.extreme.base.core.BcUnicode;

public class BcTimeParser {
    protected final int MODE_init = 0;
    protected final int MODE_era = 11;
    protected final int MODE_yyyy = 12;
    protected final int MODE_MM = 13;
    protected final int MODE_dd = 14;
    protected final int MODE_ampm = 21;
    protected final int MODE_HH = 22;
    protected final int MODE_mm = 23;
    protected final int MODE_ss = 24;
    protected final int MODE_SSS = 25;
    protected List<Character> dateDelimiterList = new ArrayList<Character>();
    protected List<Character> timeDelimiterList = new ArrayList<Character>();

    public BcTimeParser() {
        this.dateDelimiterList.add(Character.valueOf(BcUnicode.Unicode.SOLIDUS.char_));
        this.dateDelimiterList.add(Character.valueOf(BcUnicode.Unicode.HYPHEN.char_));
        this.dateDelimiterList.add(Character.valueOf(BcUnicode.Unicode.PERIOD.char_));
        this.timeDelimiterList.add(Character.valueOf(BcUnicode.Unicode.COLON.char_));
    }

    public Calendar parseToCalendar(String src, boolean isLenient, boolean isActualMaximum, int y2Base) throws Exception {
        Calendar calendar = null;
        DateTimeStructureForParse dateTimeStructure = this.parseToStructure(src);
        if (dateTimeStructure != null && (calendar = this.parseToCalendar(dateTimeStructure, isActualMaximum, y2Base)) != null) {
            calendar.setLenient(isLenient);
            if (!isLenient && !BcTimeUtil.isStrict(calendar)) {
                calendar = null;
            }
        }
        return calendar;
    }

    public DateTimeStructureForParse parseToStructure(String src) throws Exception {
        String src2 = BcStringUtil.trim(src);
        src2 = BcStringUtil.toLatinBasic(src2, 2).toString();
        src2 = BcUnicode.replace(ConvCharacter.HYPHEN, src2);
        DateTimeStructureForParse dateTimeStructure = new DateTimeStructureForParse();
        StringBuilder sb = new StringBuilder();
        int pos = -1;
        char aCHar = '\u0000';
        int mode = 11;
        boolean isLast = false;
        boolean b1 = false;
        while (++pos < src2.length()) {
            if (pos == src2.length() - 1) {
                isLast = true;
            }
            aCHar = src2.charAt(pos);
            switch (mode) {
                case 11: {
                    if (aCHar >= '0' && aCHar <= '9') {
                        dateTimeStructure.era = sb.toString();
                        sb.delete(0, sb.length());
                        sb.append(aCHar);
                        mode = 12;
                        b1 = false;
                        break;
                    }
                    if (aCHar == ' ' || aCHar == ' ') break;
                    sb.append(aCHar);
                    break;
                }
                case 12: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u5e74') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.year = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 13;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.year = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 13: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u6708') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.month = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 14;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 14: {
                    if (BcStringUtil.isSpace(aCHar)) {
                        if (sb.length() <= 0) break;
                        b1 = true;
                    } else if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u65e5') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.day = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 21;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.day = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 21;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 21: {
                    if (BcStringUtil.isSpace(aCHar) || aCHar == '\u65e5') break;
                    if (aCHar >= '0' && aCHar <= '9') {
                        dateTimeStructure.ampm = sb.toString();
                        sb.delete(0, sb.length());
                        sb.append(aCHar);
                        mode = 22;
                        b1 = false;
                        break;
                    }
                    if (BcStringUtil.isSpace(aCHar)) break;
                    sb.append(aCHar);
                    break;
                }
                case 22: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isTimeSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u6642') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.hour = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 23;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.hour = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 23;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 23: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isTimeSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u5206') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.minute = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 24;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.minute = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 24;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 24: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (aCHar == BcUnicode.Unicode.PERIOD.char_) {
                        b1 = true;
                    } else if (aCHar == '\u79d2') {
                        b1 = true;
                    }
                    if (b1) {
                        dateTimeStructure.second = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 25;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.second = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 25;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 25: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (b1) {
                        dateTimeStructure.milliSecond = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        dateTimeStructure.milliSecond = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    sb.append(aCHar);
                }
            }
        }
        StringBuilder dateSb = new StringBuilder();
        if (!BcStringUtil.isEmpty(dateTimeStructure.year)) {
            dateSb.append(dateTimeStructure.year);
        }
        if (!BcStringUtil.isEmpty(dateTimeStructure.month)) {
            dateSb.append(dateTimeStructure.month);
        }
        if (!BcStringUtil.isEmpty(dateTimeStructure.day)) {
            dateSb.append(dateTimeStructure.day);
        }
        if (dateSb.toString().equals(BcStringUtil.fill("0", dateSb.length()))) {
            return null;
        }
        if (dateSb.toString().equals(BcStringUtil.fill("9", dateSb.length()))) {
            dateTimeStructure.year = Integer.toString(10007);
            dateTimeStructure.month = Integer.toString(6);
            dateTimeStructure.day = Integer.toString(7);
            return dateTimeStructure;
        }
        if (BcStringUtil.equals(dateTimeStructure.year, dateSb.toString()) && (dateSb.length() == 6 || dateSb.length() == 8)) {
            int posMM = dateSb.length() - 4;
            dateTimeStructure.year = dateSb.substring(0, posMM);
            dateTimeStructure.month = dateSb.substring(posMM, posMM + 2);
            dateTimeStructure.day = dateSb.substring(posMM + 2, posMM + 4);
        }
        return dateTimeStructure;
    }

    public Calendar parseToCalendar(DateTimeStructureForParse dateTimeStructure, boolean isActualMaximum, int y2Base) throws Exception {
        int eraStartDate = -1;
        if (!BcStringUtil.isEmpty(dateTimeStructure.era) && (eraStartDate = BcTimeUtil_JP.getEraStartDateByAny(dateTimeStructure.era)) <= 0) {
            return null;
        }
        int yyyy = BcNumberUtil.parseInteger(dateTimeStructure.year, 0);
        if (eraStartDate <= 0) {
            yyyy += BcTimeUtil.yyToYbase(yyyy, y2Base);
        } else {
            Calendar tmpCalendar = BcTimeUtil.toCalendar(eraStartDate);
            yyyy += tmpCalendar.get(1) - 1;
        }
        int MM = BcNumberUtil.parseInteger(dateTimeStructure.month, 0);
        int dd = BcNumberUtil.parseInteger(dateTimeStructure.day, 0);
        Calendar resCalendar = null;
        if (isActualMaximum) {
            Calendar tmpCalendar1 = BcTimeUtil.createCalendar();
            tmpCalendar1.set(yyyy, MM - 1, 1, 0, 0, 0);
            tmpCalendar1.set(14, 0);
            Calendar tmpCalendar2 = BcTimeUtil.toMonthEnd(tmpCalendar1);
            if (tmpCalendar2.get(5) >= dd) {
                tmpCalendar1.set(yyyy, MM - 1, dd, 0, 0, 0);
                resCalendar = tmpCalendar1;
            } else {
                tmpCalendar1.set(yyyy, MM - 1, tmpCalendar2.get(5), 0, 0, 0);
                resCalendar = tmpCalendar1;
            }
        } else {
            Calendar tmpCalendar = BcTimeUtil.createCalendar();
            tmpCalendar.clear();
            tmpCalendar.set(yyyy, MM - 1, dd);
            resCalendar = tmpCalendar;
        }
        if (!BcStringUtil.isEmpty(dateTimeStructure.hour)) {
            int HH = BcNumberUtil.parseInt(dateTimeStructure.hour, 0);
            HH = BcTimeUtil.toHourOfDay(HH, dateTimeStructure.ampm);
            int mm = BcNumberUtil.parseInt(dateTimeStructure.minute, 0);
            int ss = BcNumberUtil.parseInt(dateTimeStructure.second, 0);
            int SSS = BcNumberUtil.parseInt(dateTimeStructure.milliSecond, 0);
            resCalendar.set(11, HH);
            resCalendar.set(12, mm);
            resCalendar.set(13, ss);
            resCalendar.set(14, SSS);
        }
        return resCalendar;
    }

    protected boolean isDateSep(char aCahr) {
        return this.dateDelimiterList.indexOf(Character.valueOf(aCahr)) >= 0;
    }

    protected boolean isTimeSep(char aCahr) {
        return this.timeDelimiterList.indexOf(Character.valueOf(aCahr)) >= 0;
    }

    public String toString(DateTimeStructureForParse dateTimeStructure) {
        StringBuilder sb = new StringBuilder();
        sb.append("era=" + dateTimeStructure.era);
        sb.append(" year=" + dateTimeStructure.year);
        sb.append(" month=" + dateTimeStructure.month);
        sb.append(" day=" + dateTimeStructure.day);
        sb.append(" ampm=" + dateTimeStructure.ampm);
        sb.append(" hour=" + dateTimeStructure.hour);
        sb.append(" minute=" + dateTimeStructure.minute);
        sb.append(" second=" + dateTimeStructure.second);
        sb.append(" milliSecond=" + dateTimeStructure.milliSecond);
        return sb.toString();
    }

    public static enum ConvCharacter implements BcUnicode.CharacterConverter
    {
        HYPHEN(BcUnicode.Unicode.HYPHEN, BcUnicode.Unicode.FULLWIDTH_HYPHEN, BcUnicode.Unicode.FULLWIDTH_NON_BREAKING_HYPHEN, BcUnicode.Unicode.FULLWIDTH_FIGURE_DASH, BcUnicode.Unicode.FULLWIDTH_EN_DASH, BcUnicode.Unicode.FULLWIDTH_EM_DASH, BcUnicode.Unicode.FULLWIDTH_HORIZONTAL_BAR, BcUnicode.Unicode.FULLWIDTH_MINUS_SIGN, BcUnicode.Unicode.FULLWIDTH_\u4e2d\u9ed2\u70b9, BcUnicode.Unicode.FULLWIDTH_HYPHEN_MINUS),
        PERIOD(BcUnicode.Unicode.PERIOD, BcUnicode.Unicode.FULLWIDTH_TILDE),
        SOLIDUS(BcUnicode.Unicode.SOLIDUS, BcUnicode.Unicode.fullwidthFullStop),
        COLON(BcUnicode.Unicode.COLON, BcUnicode.Unicode.FULLWIDTH_COLON);

        public final BcUnicode.Unicode newUnicode;
        public final BcUnicode.Unicode[] oldUnicodes;

        private ConvCharacter(BcUnicode.Unicode newUnicode, BcUnicode.Unicode ... oldUnicodes) {
            this.newUnicode = newUnicode;
            this.oldUnicodes = oldUnicodes;
        }

        @Override
        public int getCount() {
            return ConvCharacter.values().length;
        }

        @Override
        public BcUnicode.Unicode getNewUnicode(int index) {
            ConvCharacter convCharacter = BcLangUtil.getEnumByOrdinal(ConvCharacter.class, index);
            return convCharacter.newUnicode;
        }

        @Override
        public BcUnicode.Unicode[] getOldUnicodes(int index) {
            ConvCharacter convCharacter = BcLangUtil.getEnumByOrdinal(ConvCharacter.class, index);
            return convCharacter.oldUnicodes;
        }
    }

    public static class DateTimeStructureForParse {
        public String era;
        public String year;
        public String month;
        public String day;
        public String ampm;
        public String hour;
        public String minute;
        public String second;
        public String milliSecond;
    }
}

