/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.swing.JOptionPane;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcConsoleHelper;
import jp.co.extreme.base.util.BcWords;

public class ApSingleInstanceHelper {
    public static String msg = "\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u8d77\u52d5\u3057\u3066\u3044\u307e\u3059\u3002";
    static BcConsoleHelper consoleHelper = new BcConsoleHelper();

    private ApSingleInstanceHelper() {
    }

    public static ApSingleInstanceHelper getInstance() {
        return SingletonHolder.instance;
    }

    public synchronized FileLock tryLock(final File file) throws Exception {
        final FileOutputStream fos = new FileOutputStream(file);
        final FileChannel fileChannel = fos.getChannel();
        final FileLock fileLock = fileChannel.tryLock();
        if (fileLock == null) {
            BcLogUtil.warning(msg);
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(null, msg, BcWords.getInstance().information, 1);
            } else {
                consoleHelper.pause(msg);
            }
            return fileLock;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (fileLock != null && fileLock.isValid()) {
                        fileLock.release();
                    }
                    fileChannel.close();
                    fos.close();
                    BcFileUtil.deleteFile(file);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        return fileLock;
    }

    /* synthetic */ ApSingleInstanceHelper(ApSingleInstanceHelper apSingleInstanceHelper) {
        this();
    }

    private static final class SingletonHolder {
        private static final ApSingleInstanceHelper instance = new ApSingleInstanceHelper(null);

        private SingletonHolder() {
        }
    }
}

