/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.viterbi.ViterbiNode;

public class ViterbiLattice {
    static final String BOS = "BOS";
    static final String EOS = "EOS";
    private final int dimension;
    private final ViterbiNode[][] startIndexArr;
    private final ViterbiNode[][] endIndexArr;
    private final int[] startSizeArr;
    private final int[] endSizeArr;

    public ViterbiLattice(int dimension) {
        this.dimension = dimension;
        this.startIndexArr = new ViterbiNode[dimension][];
        this.endIndexArr = new ViterbiNode[dimension][];
        this.startSizeArr = new int[dimension];
        this.endSizeArr = new int[dimension];
    }

    public ViterbiNode[][] getStartIndexArr() {
        return this.startIndexArr;
    }

    public ViterbiNode[][] getEndIndexArr() {
        return this.endIndexArr;
    }

    public int[] getStartSizeArr() {
        return this.startSizeArr;
    }

    public int[] getEndSizeArr() {
        return this.endSizeArr;
    }

    public void addBos() {
        ViterbiNode bosNode = new ViterbiNode(-1, BOS, 0, 0, 0, -1, ViterbiNode.Type.KNOWN);
        this.addNode(bosNode, 0, 1);
    }

    public void addEos() {
        ViterbiNode eosNode = new ViterbiNode(-1, EOS, 0, 0, 0, this.dimension - 1, ViterbiNode.Type.KNOWN);
        this.addNode(eosNode, this.dimension - 1, 0);
    }

    void addNode(ViterbiNode node, int start, int end) {
        this.addNodeToArray(node, start, this.getStartIndexArr(), this.getStartSizeArr());
        this.addNodeToArray(node, end, this.getEndIndexArr(), this.getEndSizeArr());
    }

    private void addNodeToArray(ViterbiNode node, int index, ViterbiNode[][] arr, int[] sizes) {
        int count = sizes[index];
        this.expandIfNeeded(index, arr, count);
        arr[index][count] = node;
        sizes[index] = count + 1;
    }

    private void expandIfNeeded(int index, ViterbiNode[][] arr, int count) {
        if (count == 0) {
            arr[index] = new ViterbiNode[10];
        }
        if (arr[index].length <= count) {
            arr[index] = this.extendArray(arr[index]);
        }
    }

    private ViterbiNode[] extendArray(ViterbiNode[] array) {
        ViterbiNode[] newArray = new ViterbiNode[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    boolean tokenEndsWhereCurrentTokenStarts(int startIndex) {
        return this.getEndSizeArr()[startIndex + 1] != 0;
    }
}

