/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.viterbi.MultiSearchResult;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;

public class MultiSearchMerger {
    private int baseCost;
    private List<Integer> suffixCostLowerBounds;
    private int maxCount;
    private int costSlack;

    public MultiSearchMerger(int maxCount, int costSlack) {
        this.maxCount = maxCount;
        this.costSlack = costSlack;
    }

    public MultiSearchResult merge(List<MultiSearchResult> results) {
        int i;
        int i2;
        if (results.isEmpty()) {
            return new MultiSearchResult();
        }
        this.suffixCostLowerBounds = new ArrayList<Integer>();
        for (i2 = 0; i2 < results.size(); ++i2) {
            this.suffixCostLowerBounds.add(0);
        }
        this.suffixCostLowerBounds.set(this.suffixCostLowerBounds.size() - 1, results.get(results.size() - 1).getCost(0));
        for (i2 = results.size() - 2; i2 >= 0; --i2) {
            this.suffixCostLowerBounds.set(i2, results.get(i2).getCost(0) + this.suffixCostLowerBounds.get(i2 + 1));
        }
        this.baseCost = this.suffixCostLowerBounds.get(0);
        MultiSearchResult ret = new MultiSearchResult();
        List<MergeBuilder> builders = new ArrayList<MergeBuilder>();
        for (i = 0; i < results.get(0).size() && this.getCostLowerBound(results.get(0).getCost(i), 0) - this.baseCost <= this.costSlack && i != this.maxCount; ++i) {
            MergeBuilder newBuilder = new MergeBuilder(results);
            newBuilder.add(i);
            builders.add(newBuilder);
        }
        for (i = 1; i < results.size(); ++i) {
            builders = this.mergeStep(builders, results, i);
        }
        for (MergeBuilder builder : builders) {
            ret.add(builder.buildList(), builder.getCost());
        }
        return ret;
    }

    private List<MergeBuilder> mergeStep(List<MergeBuilder> builders, List<MultiSearchResult> results, int currentIndex) {
        MergePair top;
        MultiSearchResult nextResult = results.get(currentIndex);
        PriorityQueue<MergePair> pairHeap = new PriorityQueue<MergePair>();
        ArrayList<MergeBuilder> ret = new ArrayList<MergeBuilder>();
        if (builders.isEmpty() || nextResult.size() == 0) {
            return ret;
        }
        pairHeap.add(new MergePair(0, 0, builders.get(0).getCost() + nextResult.getCost(0)));
        HashSet<Integer> visited = new HashSet<Integer>();
        while (ret.size() < this.maxCount && pairHeap.size() > 0 && this.getCostLowerBound((top = (MergePair)pairHeap.poll()).getCost(), currentIndex) - this.baseCost <= this.costSlack) {
            int positionValue;
            MergePair newMergePair;
            int i = top.getLeftIndex();
            int j = top.getRightIndex();
            MergeBuilder nextBuilder = new MergeBuilder(results, builders.get(i).getIndices());
            nextBuilder.add(j);
            ret.add(nextBuilder);
            if (i + 1 < builders.size()) {
                newMergePair = new MergePair(i + 1, j, builders.get(i + 1).getCost() + nextResult.getCost(j));
                positionValue = this.getPositionValue(i + 1, j);
                if (!visited.contains(positionValue)) {
                    pairHeap.add(newMergePair);
                    visited.add(positionValue);
                }
            }
            if (j + 1 >= nextResult.size()) continue;
            newMergePair = new MergePair(i, j + 1, builders.get(i).getCost() + nextResult.getCost(j + 1));
            positionValue = this.getPositionValue(i, j + 1);
            if (visited.contains(positionValue)) continue;
            pairHeap.add(newMergePair);
            visited.add(positionValue);
        }
        return ret;
    }

    private int getPositionValue(int i, int j) {
        return (this.maxCount + 1) * i + j;
    }

    private int getCostLowerBound(int currentCost, int index) {
        if (index + 1 < this.suffixCostLowerBounds.size()) {
            return currentCost + this.suffixCostLowerBounds.get(index + 1);
        }
        return currentCost;
    }

    private class MergePair
    implements Comparable<MergePair> {
        private int leftIndex;
        private int rightIndex;
        private int cost;

        public MergePair(int leftIndex, int rightIndex, int cost) {
            this.leftIndex = leftIndex;
            this.rightIndex = rightIndex;
            this.cost = cost;
        }

        public int getLeftIndex() {
            return this.leftIndex;
        }

        public int getRightIndex() {
            return this.rightIndex;
        }

        public int getCost() {
            return this.cost;
        }

        @Override
        public int compareTo(MergePair o) {
            return this.cost - o.getCost();
        }
    }

    private class MergeBuilder
    implements Comparable<MergeBuilder> {
        private int cost;
        private List<Integer> indices;
        private List<MultiSearchResult> results;

        public MergeBuilder(List<MultiSearchResult> results) {
            this.results = results;
            this.cost = 0;
            this.indices = new ArrayList<Integer>();
        }

        public MergeBuilder(List<MultiSearchResult> results, List<Integer> indices) {
            this(results);
            for (Integer index : indices) {
                this.add(index);
            }
        }

        public List<ViterbiNode> buildList() {
            ArrayList<ViterbiNode> ret = new ArrayList<ViterbiNode>();
            for (int i = 0; i < this.indices.size(); ++i) {
                ret.addAll(this.results.get(i).getTokenizedResult(this.indices.get(i)));
            }
            return ret;
        }

        public void add(int index) {
            this.indices.add(index);
            this.cost += this.results.get(this.indices.size() - 1).getCost(index);
        }

        public int getCost() {
            return this.cost;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }

        @Override
        public int compareTo(MergeBuilder o) {
            return this.cost - o.cost;
        }
    }
}

