/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.fst;

import com.atilika.kuromoji.fst.Arc;
import com.atilika.kuromoji.fst.State;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class Compiler {
    public static final byte STATE_TYPE_MATCH = 0;
    public static final byte STATE_TYPE_ACCEPT = -128;
    private ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
    private DataOutput dataOutput = new DataOutputStream(this.byteArrayOutput);
    private int written = 0;

    public void compileState(State state) throws IOException {
        if (state.getTargetJumpAddress() == -1) {
            int jumpBytes = this.findMaxJumpAddressBytes(state);
            int outputBytes = this.findMaxOutputBytes(state);
            this.writeStateArcs(state, outputBytes, jumpBytes);
            this.writeStateType(state, outputBytes, jumpBytes);
            state.setTargetJumpAddress(this.written - 1);
        }
    }

    private void writeStateType(State state, int outputBytes, int jumpBytes) throws IOException {
        int stateType = state.isFinal() ? -128 : 0;
        stateType = (byte)(stateType | jumpBytes - 1);
        stateType = (byte)(stateType | outputBytes << 3);
        this.dataOutput.writeByte(stateType);
        ++this.written;
    }

    private void writeStateArcs(State state, int outputBytes, int jumpBytes) throws IOException {
        List<Arc> arcs = state.arcs;
        for (Arc arc : arcs) {
            this.writeStateArc(arc, outputBytes, jumpBytes);
        }
        this.dataOutput.writeShort(arcs.size());
        this.written += 2;
    }

    private void writeStateArc(Arc arc, int outputBytes, int jumpBytes) throws IOException {
        State target = arc.getDestination();
        int arcSize = 2 + jumpBytes + outputBytes;
        this.dataOutput.writeShort(arc.getLabel());
        this.writeIntValue(target.getTargetJumpAddress(), jumpBytes);
        this.writeIntValue(arc.getOutput(), outputBytes);
        this.written += arcSize;
    }

    private void writeIntValue(int value, int bytes) throws IOException {
        switch (bytes) {
            case 0: {
                break;
            }
            case 1: {
                this.dataOutput.writeByte(value & 0xFF);
                break;
            }
            case 2: {
                this.dataOutput.writeByte(value >> 8 & 0xFF);
                this.dataOutput.writeByte(value & 0xFF);
                break;
            }
            case 3: {
                this.dataOutput.writeByte(value >> 16 & 0xFF);
                this.dataOutput.writeByte(value >> 8 & 0xFF);
                this.dataOutput.writeByte(value & 0xFF);
                break;
            }
            case 4: {
                this.dataOutput.writeByte(value >> 24 & 0xFF);
                this.dataOutput.writeByte(value >> 16 & 0xFF);
                this.dataOutput.writeByte(value >> 8 & 0xFF);
                this.dataOutput.writeByte(value & 0xFF);
                break;
            }
            default: {
                throw new RuntimeException("Illegal int byte size: " + bytes);
            }
        }
    }

    private int findMaxJumpAddressBytes(State state) {
        int maxJumpAddress = 0;
        for (Arc arc : state.arcs) {
            int jumpAddress = arc.getDestination().getTargetJumpAddress();
            if (maxJumpAddress >= jumpAddress) continue;
            maxJumpAddress = jumpAddress;
        }
        return this.findBytes(maxJumpAddress);
    }

    private int findMaxOutputBytes(State state) {
        int maxOutput = 0;
        for (Arc arc : state.arcs) {
            int output = arc.getOutput();
            if (maxOutput >= output) continue;
            maxOutput = output;
        }
        if (maxOutput == 0) {
            return 0;
        }
        return this.findBytes(maxOutput);
    }

    private int findBytes(int value) {
        if (value < 256) {
            return 1;
        }
        if (value < 65536) {
            return 2;
        }
        if (value < 0x1000000) {
            return 3;
        }
        return 4;
    }

    public byte[] getBytes() {
        return this.byteArrayOutput.toByteArray();
    }
}

