/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.fst;

import com.atilika.kuromoji.fst.Arc;
import com.atilika.kuromoji.fst.Compiler;
import com.atilika.kuromoji.fst.State;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Builder {
    private Map<Integer, List<State>> statesDictionary;
    private Compiler compiler = new Compiler();
    private List<State> tempStates;

    public Builder() {
        LinkedList<State> stateList = new LinkedList<State>();
        stateList.add(new State());
        this.statesDictionary = new HashMap<Integer, List<State>>();
        this.statesDictionary.put(0, stateList);
        this.tempStates = new ArrayList<State>();
        this.tempStates.add(this.getStartState());
    }

    public int transduce(String input) {
        State currentState = this.getStartState();
        int output = 0;
        for (int i = 0; i < input.length(); ++i) {
            char currentTransition = input.charAt(i);
            Arc nextArc = currentState.findArc(currentTransition);
            if (nextArc == null) {
                return -1;
            }
            currentState = nextArc.getDestination();
            output += nextArc.getOutput();
        }
        return output;
    }

    public State getStartState() {
        return this.statesDictionary.get(0).get(0);
    }

    public void createDictionaryIncremental(Reader reader) throws IOException {
        String line;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String previousWord = "";
        int outputValue = 1;
        while ((line = lineNumberReader.readLine()) != null) {
            if ((line = line.replaceAll("#.*$", "")).trim().isEmpty()) continue;
            String inputWord = line;
            this.createDictionaryCommon(inputWord, previousWord, outputValue);
            previousWord = inputWord;
            ++outputValue;
        }
        this.handleLastWord(previousWord);
    }

    public void build(String[] inputWords, int[] outputValues) throws IOException {
        String previousWord = "";
        for (int inputWordIdx = 0; inputWordIdx < inputWords.length; ++inputWordIdx) {
            String inputWord = inputWords[inputWordIdx];
            this.createDictionaryCommon(inputWord, previousWord, outputValues == null ? inputWordIdx + 1 : outputValues[inputWordIdx]);
            previousWord = inputWord;
        }
        this.handleLastWord(previousWord);
    }

    private void createDictionaryCommon(String inputWord, String previousWord, int currentOutput) throws IOException {
        int i;
        int commonPrefixLengthPlusOne = this.commonPrefixIndice(previousWord, inputWord) + 1;
        if (inputWord.length() >= this.tempStates.size()) {
            for (int j = this.tempStates.size(); j <= inputWord.length(); ++j) {
                this.tempStates.add(new State());
            }
        }
        for (i = previousWord.length(); i >= commonPrefixLengthPlusOne; --i) {
            this.freezeAndPointToNewState(previousWord, i);
        }
        for (i = commonPrefixLengthPlusOne; i <= inputWord.length(); ++i) {
            this.tempStates.set(i, new State());
            this.tempStates.get(i - 1).setArc(inputWord.charAt(i - 1), this.tempStates.get(i));
        }
        this.tempStates.get(inputWord.length()).setFinal();
        State currentState = this.tempStates.get(0);
        for (int i2 = 0; i2 < commonPrefixLengthPlusOne - 1; ++i2) {
            Arc nextArc = currentState.findArc(inputWord.charAt(i2));
            currentOutput = this.excludePrefix(currentOutput, nextArc.getOutput());
            currentState = nextArc.getDestination();
        }
        State suffixHeadState = this.tempStates.get(commonPrefixLengthPlusOne - 1);
        suffixHeadState.findArc(inputWord.charAt(commonPrefixLengthPlusOne - 1)).setOutput(currentOutput);
    }

    private void freezeAndPointToNewState(String previousWord, int i) throws IOException {
        State state = this.tempStates.get(i - 1);
        char previousWordChar = previousWord.charAt(i - 1);
        int output = state.findArc(previousWordChar).getOutput();
        state.arcs.remove(state.findArc(previousWordChar));
        Arc arcToFrozenState = state.setArc(previousWordChar, output, this.findEquivalentState(this.tempStates.get(i)));
        this.compiler.compileState(arcToFrozenState.getDestination());
    }

    private void handleLastWord(String previousWord) throws IOException {
        for (int i = previousWord.length(); i > 0; --i) {
            this.freezeAndPointToNewState(previousWord, i);
        }
        this.compileStartingState();
        this.findEquivalentState(this.tempStates.get(0));
    }

    private void compileStartingState() throws IOException {
        this.compiler.compileState(this.tempStates.get(0));
    }

    private int commonPrefixIndice(String prevWord, String currentWord) {
        int i;
        for (i = 0; i < prevWord.length() && i < currentWord.length() && prevWord.charAt(i) == currentWord.charAt(i); ++i) {
        }
        return i;
    }

    private int excludePrefix(int word, int prefix) {
        return word - prefix;
    }

    private State findEquivalentState(State state) {
        Integer key = state.hashCode();
        if (this.statesDictionary.containsKey(key)) {
            if (state.arcs.size() == 0) {
                return this.statesDictionary.get(key).get(0);
            }
            for (State collidedState : this.statesDictionary.get(key)) {
                if (!state.equals(collidedState)) continue;
                return collidedState;
            }
        }
        State newStateToDic = new State(state);
        List<State> stateList = new LinkedList<State>();
        if (this.statesDictionary.containsKey(key)) {
            stateList = this.statesDictionary.get(key);
        }
        stateList.add(newStateToDic);
        this.statesDictionary.put(key, stateList);
        return newStateToDic;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }
}

