/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.fst;

import com.atilika.kuromoji.fst.Bits;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitsFormatter {
    private ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();

    public String format(InputStream input) throws IOException {
        int nextByte;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        while ((nextByte = bufferedInput.read()) >= 0) {
            this.byteOutput.write(nextByte);
        }
        return this.format(this.byteOutput.toByteArray());
    }

    public String format(byte[] fst) {
        StringBuilder builder = new StringBuilder();
        for (int address = fst.length - 1; address > 0; address -= this.stateSize(fst, address)) {
            builder.append(this.formatState(fst, address));
        }
        return builder.toString();
    }

    public int stateSize(byte[] fst, int address) {
        byte stateTypByte = Bits.getByte(fst, address);
        int jumpBytes = (stateTypByte & 3) + 1;
        int accumulateBytes = (stateTypByte & 0x18) >> 3;
        return 3 + Bits.getShort(fst, address - 1) * (2 + accumulateBytes + jumpBytes);
    }

    public String formatState(byte[] fst, int address) {
        StringBuilder builder = new StringBuilder();
        byte stateByte = Bits.getByte(fst, address);
        byte stateType = (byte)(stateByte & 0x80);
        int jumpBytes = (stateByte & 3) + 1;
        int accumulateBytes = (stateByte & 0x18) >> 3;
        builder.append(this.formatStateType(stateType, address));
        builder.append(this.formatArcs(fst, address - 1, accumulateBytes, jumpBytes));
        return builder.toString();
    }

    public String formatStateType(byte stateByte, int address) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatAddress(address));
        builder.append(" ");
        if (stateByte == -128) {
            builder.append("ACCEPT");
        } else if (stateByte == 0) {
            builder.append("MATCH");
        } else {
            throw new IllegalStateException("Illegal state type: " + stateByte);
        }
        builder.append("\n");
        return builder.toString();
    }

    public String formatAddress(int address) {
        return String.format("%4d:", address);
    }

    public String formatArcs(byte[] fst, int address, int accumulateBytes, int jumpBytes) {
        StringBuilder builder = new StringBuilder();
        int arcs = Bits.getShort(fst, address);
        address -= 2;
        for (int i = 0; i < arcs; ++i) {
            builder.append(this.formatAddress(address));
            builder.append(this.formatArc(fst, address, accumulateBytes, jumpBytes));
            builder.append("\n");
            address -= 2 + accumulateBytes + jumpBytes;
        }
        return builder.toString();
    }

    public String formatArc(byte[] fst, int address, int accumulateBytes, int jumpBytes) {
        StringBuilder builder = new StringBuilder();
        int output = Bits.getInt(fst, address, accumulateBytes);
        int jumpAddress = Bits.getInt(fst, address -= accumulateBytes, jumpBytes);
        char label = (char)Bits.getShort(fst, address -= jumpBytes);
        builder.append('\t');
        builder.append(label);
        builder.append(" -> ");
        builder.append(output);
        builder.append("\t(JMP: ");
        builder.append(jumpAddress);
        builder.append(')');
        return builder.toString();
    }
}

