/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.trie.PatriciaTrie;
import com.atilika.kuromoji.util.DictionaryEntryLineParser;
import com.atilika.kuromoji.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserDictionary
implements Dictionary {
    private static final int SIMPLE_USERDICT_FIELDS = 4;
    private static final int WORD_COST_BASE = -100000;
    public static final int MINIMUM_WORD_COST = -1073741824;
    private static final int LEFT_ID = 5;
    private static final int RIGHT_ID = 5;
    private static final String DEFAULT_FEATURE = "*";
    private static final String FEATURE_SEPARATOR = ",";
    private final List<UserDictionaryEntry> entries = new ArrayList<UserDictionaryEntry>();
    private final int readingFeature;
    private final int partOfSpeechFeature;
    private final int totalFeatures;
    private PatriciaTrie<int[]> surfaces = new PatriciaTrie();

    public UserDictionary(InputStream input, int totalFeatures, int readingFeature, int partOfSpeechFeature) throws IOException {
        this.totalFeatures = totalFeatures;
        this.readingFeature = readingFeature;
        this.partOfSpeechFeature = partOfSpeechFeature;
        this.read(input);
    }

    public List<UserDictionaryMatch> findUserDictionaryMatches(String text) {
        ArrayList<UserDictionaryMatch> matchInfos = new ArrayList<UserDictionaryMatch>();
        for (int startIndex = 0; startIndex < text.length(); ++startIndex) {
            String match;
            int[] details;
            int matchLength = 0;
            int endIndex = 0;
            while (this.currentInputContainsPotentialMatch(text, startIndex, endIndex)) {
                String matchCandidate = text.substring(startIndex, startIndex + endIndex);
                if (this.surfaces.containsKey(matchCandidate)) {
                    matchLength = endIndex;
                }
                ++endIndex;
            }
            if (matchLength <= 0 || (details = this.surfaces.get(match = text.substring(startIndex, startIndex + matchLength))) == null) continue;
            matchInfos.addAll(this.makeMatchDetails(startIndex, details));
        }
        return matchInfos;
    }

    private boolean currentInputContainsPotentialMatch(String text, int startIndex, int endIndex) {
        return startIndex + endIndex <= text.length() && this.surfaces.containsKeyPrefix(text.substring(startIndex, startIndex + endIndex));
    }

    @Override
    public int getLeftId(int wordId) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getLeftId();
    }

    @Override
    public int getRightId(int wordId) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getRightId();
    }

    @Override
    public int getWordCost(int wordId) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getWordCost();
    }

    @Override
    public String getAllFeatures(int wordId) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getAllFeatures();
    }

    @Override
    public String[] getAllFeaturesArray(int wordId) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getAllFeaturesArray();
    }

    @Override
    public String getFeature(int wordId, int ... fields) {
        UserDictionaryEntry entry = this.entries.get(wordId);
        return entry.getFeature(fields);
    }

    private List<UserDictionaryMatch> makeMatchDetails(int matchStartIndex, int[] details) {
        ArrayList<UserDictionaryMatch> matchDetails = new ArrayList<UserDictionaryMatch>(details.length - 1);
        int wordId = details[0];
        int startIndex = 0;
        for (int i = 1; i < details.length; ++i) {
            int matchLength = details[i];
            matchDetails.add(new UserDictionaryMatch(wordId, matchStartIndex + startIndex, matchLength));
            startIndex += matchLength;
            ++wordId;
        }
        return matchDetails;
    }

    private void read(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("#.*$", "");
            if ((line = line.trim()).isEmpty()) continue;
            this.addEntry(line);
        }
    }

    public void addEntry(String entry) {
        String[] values = DictionaryEntryLineParser.parseLine(entry);
        if (values.length == 4) {
            this.addSimpleEntry(values);
        } else if (values.length == this.totalFeatures + 4) {
            this.addFullEntry(values);
        } else {
            throw new RuntimeException("Illegal user dictionary entry " + entry);
        }
    }

    private void addFullEntry(String[] values) {
        String surface = values[0];
        int[] costs = new int[]{Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3])};
        String[] features = Arrays.copyOfRange(values, 4, values.length);
        UserDictionaryEntry entry = new UserDictionaryEntry(surface, costs, features);
        int[] wordIdAndLengths = new int[]{this.entries.size(), surface.length()};
        this.entries.add(entry);
        this.surfaces.put(surface, wordIdAndLengths);
    }

    private void addSimpleEntry(String[] values) {
        int wordId;
        String[] readings;
        String[] segmentation;
        String surface = values[0];
        String segmentationValue = values[1];
        String readingsValue = values[2];
        String partOfSpeech = values[3];
        if (this.isCustomSegmentation(surface, segmentationValue)) {
            segmentation = this.split(segmentationValue);
            readings = this.split(readingsValue);
        } else {
            segmentation = new String[]{segmentationValue};
            readings = new String[]{readingsValue};
        }
        if (segmentation.length != readings.length) {
            throw new RuntimeException("User dictionary entry not properly formatted: " + Arrays.asList(values));
        }
        int[] wordIdAndLengths = new int[segmentation.length + 1];
        wordIdAndLengths[0] = wordId = this.entries.size();
        for (int i = 0; i < segmentation.length; ++i) {
            wordIdAndLengths[i + 1] = segmentation[i].length();
            String[] features = this.makeSimpleFeatures(partOfSpeech, readings[i]);
            int[] costs = this.makeCosts(surface.length());
            UserDictionaryEntry entry = new UserDictionaryEntry(segmentation[i], costs, features);
            this.entries.add(entry);
        }
        this.surfaces.put(surface, wordIdAndLengths);
    }

    private int[] makeCosts(int length) {
        int wordCost = -100000 * length;
        if (wordCost < -1073741824) {
            wordCost = -1073741824;
        }
        return new int[]{5, 5, wordCost};
    }

    private String[] makeSimpleFeatures(String partOfSpeech, String reading) {
        String[] features = this.emptyFeatureArray();
        features[this.partOfSpeechFeature] = partOfSpeech;
        features[this.readingFeature] = reading;
        return features;
    }

    private String[] emptyFeatureArray() {
        String[] features = new String[this.totalFeatures];
        for (int i = 0; i < features.length; ++i) {
            features[i] = DEFAULT_FEATURE;
        }
        return features;
    }

    private boolean isCustomSegmentation(String surface, String segmentation) {
        return !surface.equals(segmentation);
    }

    private String[] split(String input) {
        return input.split("\\s+");
    }

    private class UserDictionaryEntry {
        private String surface;
        private int[] costs;
        private String[] features;

        public UserDictionaryEntry(String surface, int[] costs, String[] features) {
            this.surface = surface;
            this.costs = costs;
            this.features = features;
        }

        public String getSurface() {
            return this.surface;
        }

        public int getLeftId() {
            return this.costs[0];
        }

        public int getRightId() {
            return this.costs[1];
        }

        public int getWordCost() {
            return this.costs[2];
        }

        public String[] getAllFeaturesArray() {
            return this.features;
        }

        public String getAllFeatures() {
            return StringUtils.join(this.features, UserDictionary.FEATURE_SEPARATOR);
        }

        public String getFeature(int ... fields) {
            String[] f = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                int featureNumber = fields[i];
                f[i] = this.features[featureNumber];
            }
            return StringUtils.join(f, UserDictionary.FEATURE_SEPARATOR);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.surface);
            builder.append(UserDictionary.FEATURE_SEPARATOR);
            builder.append(this.costs[0]);
            builder.append(UserDictionary.FEATURE_SEPARATOR);
            builder.append(this.costs[1]);
            builder.append(UserDictionary.FEATURE_SEPARATOR);
            builder.append(this.costs[2]);
            builder.append(UserDictionary.FEATURE_SEPARATOR);
            builder.append(StringUtils.join(this.features, UserDictionary.FEATURE_SEPARATOR));
            return builder.toString();
        }
    }

    public static class UserDictionaryMatch {
        private final int wordId;
        private final int matchStartIndex;
        private final int matchLength;

        public UserDictionaryMatch(int wordId, int matchStartIndex, int matchLength) {
            this.wordId = wordId;
            this.matchStartIndex = matchStartIndex;
            this.matchLength = matchLength;
        }

        public int getWordId() {
            return this.wordId;
        }

        public int getMatchStartIndex() {
            return this.matchStartIndex;
        }

        public int getMatchLength() {
            return this.matchLength;
        }

        public String toString() {
            return "UserDictionaryMatch{wordId=" + this.wordId + ", matchStartIndex=" + this.matchStartIndex + ", matchLength=" + this.matchLength + '}';
        }
    }
}

