/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static final int HEX = 16;
    private static final String[] WS_ENTITIES = new String[5];
    private static final String NS = "ns";
    private boolean xmlDeclaration = true;
    private XmlNamespacePolicy namespacePolicy = XmlNamespacePolicy.IGNORE;
    private HashMap nsPrefixMap = new HashMap();
    private int nextPrefix = 0;
    private HashMap nsURIByElement = new HashMap();
    private static String lSep;
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    static {
        int i = 9;
        while (i < 14) {
            DOMElementWriter.WS_ENTITIES[i - 9] = "&#x" + Integer.toHexString(i) + ";";
            ++i;
        }
        lSep = System.getProperty("line.separator");
    }

    public DOMElementWriter() {
    }

    public DOMElementWriter(boolean xmlDeclaration) {
        this(xmlDeclaration, XmlNamespacePolicy.IGNORE);
    }

    public DOMElementWriter(boolean xmlDeclaration, XmlNamespacePolicy namespacePolicy) {
        this.xmlDeclaration = xmlDeclaration;
        this.namespacePolicy = namespacePolicy;
    }

    public void write(Element root, OutputStream out) throws IOException {
        OutputStreamWriter wri = new OutputStreamWriter(out, "UTF8");
        this.writeXMLDeclaration(wri);
        this.write(root, wri, 0, "  ");
        ((Writer)wri).flush();
    }

    public void writeXMLDeclaration(Writer wri) throws IOException {
        if (this.xmlDeclaration) {
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void write(Element element, Writer out, int indent, String indentWith) throws IOException {
        NodeList children = element.getChildNodes();
        boolean hasChildren = children.getLength() > 0;
        boolean hasChildElements = false;
        this.openElement(element, out, indent, indentWith, hasChildren);
        if (hasChildren) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 1: {
                        hasChildElements = true;
                        if (i == 0) {
                            out.write(lSep);
                        }
                        this.write((Element)child, out, indent + 1, indentWith);
                        break;
                    }
                    case 3: {
                        out.write(this.encode(child.getNodeValue()));
                        break;
                    }
                    case 8: {
                        out.write("<!--");
                        out.write(this.encode(child.getNodeValue()));
                        out.write("-->");
                        break;
                    }
                    case 4: {
                        out.write("<![CDATA[");
                        this.encodedata(out, ((Text)child).getData());
                        out.write("]]>");
                        break;
                    }
                    case 5: {
                        out.write(38);
                        out.write(child.getNodeName());
                        out.write(59);
                        break;
                    }
                    case 7: {
                        out.write("<?");
                        out.write(child.getNodeName());
                        String data = child.getNodeValue();
                        if (data != null && data.length() > 0) {
                            out.write(32);
                            out.write(data);
                        }
                        out.write("?>");
                    }
                }
                ++i;
            }
            this.closeElement(element, out, indent, indentWith, hasChildElements);
        }
    }

    public void openElement(Element element, Writer out, int indent, String indentWith) throws IOException {
        this.openElement(element, out, indent, indentWith, true);
    }

    public void openElement(Element element, Writer out, int indent, String indentWith, boolean hasChildren) throws IOException {
        String prefix;
        int i = 0;
        while (i < indent) {
            out.write(indentWith);
            ++i;
        }
        out.write("<");
        if (this.namespacePolicy.qualifyElements) {
            String uri = DOMElementWriter.getNamespaceURI(element);
            String prefix2 = (String)this.nsPrefixMap.get(uri);
            if (prefix2 == null) {
                prefix2 = this.nsPrefixMap.isEmpty() ? "" : NS + this.nextPrefix++;
                this.nsPrefixMap.put(uri, prefix2);
                this.addNSDefinition(element, uri);
            }
            if (!"".equals(prefix2)) {
                out.write(prefix2);
                out.write(":");
            }
        }
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i2 = 0;
        while (i2 < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i2);
            out.write(" ");
            if (this.namespacePolicy.qualifyAttributes) {
                String uri = DOMElementWriter.getNamespaceURI(attr);
                prefix = (String)this.nsPrefixMap.get(uri);
                if (prefix == null) {
                    prefix = NS + this.nextPrefix++;
                    this.nsPrefixMap.put(uri, prefix);
                    this.addNSDefinition(element, uri);
                }
                out.write(prefix);
                out.write(":");
            }
            out.write(attr.getName());
            out.write("=\"");
            out.write(this.encodeAttributeValue(attr.getValue()));
            out.write("\"");
            ++i2;
        }
        ArrayList al = (ArrayList)this.nsURIByElement.get(element);
        if (al != null) {
            for (String uri : al) {
                prefix = (String)this.nsPrefixMap.get(uri);
                out.write(" xmlns");
                if (!"".equals(prefix)) {
                    out.write(":");
                    out.write(prefix);
                }
                out.write("=\"");
                out.write(uri);
                out.write("\"");
            }
        }
        if (hasChildren) {
            out.write(">");
        } else {
            this.removeNSDefinitions(element);
            out.write(" />");
            out.write(lSep);
            out.flush();
        }
    }

    public void closeElement(Element element, Writer out, int indent, String indentWith, boolean hasChildren) throws IOException {
        if (hasChildren) {
            int i = 0;
            while (i < indent) {
                out.write(indentWith);
                ++i;
            }
        }
        out.write("</");
        if (this.namespacePolicy.qualifyElements) {
            String uri = DOMElementWriter.getNamespaceURI(element);
            String prefix = (String)this.nsPrefixMap.get(uri);
            if (prefix != null && !"".equals(prefix)) {
                out.write(prefix);
                out.write(":");
            }
            this.removeNSDefinitions(element);
        }
        out.write(element.getTagName());
        out.write(">");
        out.write(lSep);
        out.flush();
    }

    public String encode(String value) {
        return this.encode(value, false);
    }

    public String encodeAttributeValue(String value) {
        return this.encode(value, true);
    }

    private String encode(String value, boolean encodeWhitespace) {
        int len = value.length();
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    if (encodeWhitespace) {
                        sb.append(WS_ENTITIES[c - 9]);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (!this.isLegalCharacter(c)) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.substring(0);
    }

    public String encodedata(String value) {
        StringWriter out = new StringWriter();
        try {
            this.encodedata(out, value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }

    public void encodedata(Writer out, String value) throws IOException {
        int len = value.length();
        int prevEnd = 0;
        int cdataEndPos = value.indexOf("]]>");
        while (prevEnd < len) {
            int end = cdataEndPos < 0 ? len : cdataEndPos;
            int prevLegalCharPos = prevEnd;
            while (prevLegalCharPos < end) {
                int illegalCharPos;
                for (illegalCharPos = prevLegalCharPos; illegalCharPos < end && this.isLegalCharacter(value.charAt(illegalCharPos)); ++illegalCharPos) {
                }
                out.write(value, prevLegalCharPos, illegalCharPos - prevLegalCharPos);
                prevLegalCharPos = illegalCharPos + 1;
            }
            if (cdataEndPos >= 0) {
                out.write("]]]]><![CDATA[>");
                prevEnd = cdataEndPos + 3;
                cdataEndPos = value.indexOf("]]>", prevEnd);
                continue;
            }
            prevEnd = end;
        }
    }

    public boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        int i = 0;
        while (i < this.knownEntities.length) {
            if (name.equals(this.knownEntities[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    private void removeNSDefinitions(Element element) {
        ArrayList al = (ArrayList)this.nsURIByElement.get(element);
        if (al != null) {
            Iterator iter = al.iterator();
            while (iter.hasNext()) {
                this.nsPrefixMap.remove(iter.next());
            }
            this.nsURIByElement.remove(element);
        }
    }

    private void addNSDefinition(Element element, String uri) {
        ArrayList<String> al = (ArrayList<String>)this.nsURIByElement.get(element);
        if (al == null) {
            al = new ArrayList<String>();
            this.nsURIByElement.put(element, al);
        }
        al.add(uri);
    }

    private static String getNamespaceURI(Node n) {
        String uri = n.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        return uri;
    }

    public static class XmlNamespacePolicy {
        private boolean qualifyElements;
        private boolean qualifyAttributes;
        public static final XmlNamespacePolicy IGNORE = new XmlNamespacePolicy(false, false);
        public static final XmlNamespacePolicy ONLY_QUALIFY_ELEMENTS = new XmlNamespacePolicy(true, false);
        public static final XmlNamespacePolicy QUALIFY_ALL = new XmlNamespacePolicy(true, true);

        public XmlNamespacePolicy(boolean qualifyElements, boolean qualifyAttributes) {
            this.qualifyElements = qualifyElements;
            this.qualifyAttributes = qualifyAttributes;
        }
    }
}

