/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class DefaultLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    protected boolean emacsMode = false;

    @Override
    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    @Override
    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    @Override
    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
    }

    @Override
    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    @Override
    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    static void throwableMessage(StringBuffer m, Throwable error, boolean verbose) {
        while (error instanceof BuildException) {
            String msg2;
            String msg1;
            Throwable cause = error.getCause();
            if (cause == null || !(msg1 = error.toString()).endsWith(msg2 = cause.toString())) break;
            m.append(msg1.substring(0, msg1.length() - msg2.length()));
            error = cause;
        }
        if (verbose || !(error instanceof BuildException)) {
            m.append(StringUtils.getStackTrace(error));
        } else {
            m.append(error).append(lSep);
        }
    }

    @Override
    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            message.append(StringUtils.LINE_SEP);
            message.append(this.getBuildSuccessfulMessage());
        } else {
            message.append(StringUtils.LINE_SEP);
            message.append(this.getBuildFailedMessage());
            message.append(StringUtils.LINE_SEP);
            DefaultLogger.throwableMessage(message, error, 3 <= this.msgOutputLevel);
        }
        message.append(StringUtils.LINE_SEP);
        message.append("Total time: ");
        message.append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
        String msg = message.toString();
        if (error == null) {
            this.printMessage(msg, this.out, 3);
        } else {
            this.printMessage(msg, this.err, 0);
        }
        this.log(msg);
    }

    protected String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    @Override
    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && !event.getTarget().getName().equals("")) {
            String msg = String.valueOf(StringUtils.LINE_SEP) + event.getTarget().getName() + ":";
            this.printMessage(msg, this.out, event.getPriority());
            this.log(msg);
        }
    }

    @Override
    public void targetFinished(BuildEvent event) {
    }

    @Override
    public void taskStarted(BuildEvent event) {
    }

    @Override
    public void taskFinished(BuildEvent event) {
    }

    @Override
    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority <= this.msgOutputLevel) {
            StringBuffer message;
            block16: {
                message = new StringBuffer();
                if (event.getTask() != null && !this.emacsMode) {
                    String name = event.getTask().getTaskName();
                    String label = "[" + name + "] ";
                    int size = 12 - label.length();
                    StringBuffer tmp = new StringBuffer();
                    int i = 0;
                    while (i < size) {
                        tmp.append(" ");
                        ++i;
                    }
                    tmp.append(label);
                    label = tmp.toString();
                    BufferedReader r = null;
                    try {
                        try {
                            r = new BufferedReader(new StringReader(event.getMessage()));
                            String line = r.readLine();
                            boolean first = true;
                            do {
                                if (first) {
                                    if (line == null) {
                                        message.append(label);
                                        break;
                                    }
                                } else {
                                    message.append(StringUtils.LINE_SEP);
                                }
                                first = false;
                                message.append(label).append(line);
                            } while ((line = r.readLine()) != null);
                        }
                        catch (IOException e) {
                            message.append(label).append(event.getMessage());
                            FileUtils.close(r);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(r);
                        throw throwable;
                    }
                    FileUtils.close(r);
                } else {
                    message.append(event.getMessage());
                }
            }
            Throwable ex = event.getException();
            if (4 <= this.msgOutputLevel && ex != null) {
                message.append(StringUtils.getStackTrace(ex));
            }
            String msg = message.toString();
            if (priority != 0) {
                this.printMessage(msg, this.out, priority);
            } else {
                this.printMessage(msg, this.err, priority);
            }
            this.log(msg);
        }
    }

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime(millis);
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        stream.println(message);
    }

    protected void log(String message) {
    }

    protected String getTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        String finishTime = formatter.format(date);
        return finishTime;
    }

    protected String extractProjectName(BuildEvent event) {
        Project project = event.getProject();
        return project != null ? project.getName() : null;
    }
}

