/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super((short)170, match, targets, defaultTarget);
        short _length = (short)(13 + this.getMatch_length() * 4);
        super.setLength(_length);
        this.setFixed_length(_length);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        int _match_length = this.getMatch_length();
        int low = _match_length > 0 ? super.getMatch(0) : 0;
        out.writeInt(low);
        int high = _match_length > 0 ? super.getMatch(_match_length - 1) : 0;
        out.writeInt(high);
        int i = 0;
        while (i < _match_length) {
            out.writeInt(this.setIndices(i, this.getTargetOffset(super.getTarget(i))));
            ++i;
        }
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        int low = bytes.readInt();
        int high = bytes.readInt();
        int _match_length = high - low + 1;
        this.setMatch_length(_match_length);
        short _fixed_length = (short)(13 + _match_length * 4);
        this.setFixed_length(_fixed_length);
        super.setLength((short)(_fixed_length + super.getPadding()));
        super.setMatches(new int[_match_length]);
        super.setIndices(new int[_match_length]);
        super.setTargets(new InstructionHandle[_match_length]);
        int i = 0;
        while (i < _match_length) {
            super.setMatch(i, low + i);
            super.setIndices(i, bytes.readInt());
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitStackConsumer(this);
        v.visitBranchInstruction(this);
        v.visitSelect(this);
        v.visitTABLESWITCH(this);
    }
}

