/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.doc;

import ext.lib.doc.util.DcfPageReader;
import ext.lib.doc.util.DcfPageWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nlc.lib.doc.DcfOutlineNode;
import nlc.lib.doc.DcfPage;
import nlc.lib.tree.LbTreeModel;

public class DcfBook
implements DcfPageWriter,
DcfPageReader,
Serializable {
    private static final long serialVersionUID = 1983337631369634495L;
    protected String title;
    protected String author;
    protected List<DcfPage> pageList;
    protected boolean bgPageEnabled;
    protected Map<String, DcfPage> bgPageMap;
    public DcfOutlineNode rootNode;
    public LbTreeModel outlineTree;

    public DcfBook() throws Exception {
        this.clear();
    }

    public void clear() throws Exception {
        this.title = null;
        this.author = null;
        this.pageList = new ArrayList<DcfPage>();
        this.bgPageMap = new HashMap<String, DcfPage>();
        this.bgPageEnabled = true;
        this.rootNode = new DcfOutlineNode();
        this.outlineTree = new LbTreeModel(this.rootNode);
    }

    @Override
    public String getTitle() throws Exception {
        return this.title;
    }

    @Override
    public void setTitle(String title) throws Exception {
        this.title = title;
    }

    @Override
    public String getAuthor() throws Exception {
        return this.author;
    }

    @Override
    public void setAuthor(String author) throws Exception {
        this.author = author;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addPage(DcfPage dcfPage) throws Exception {
        if (dcfPage == null) {
            throw new Exception("\u30d6\u30c3\u30af\u306bNULL\u306f\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        List<DcfPage> list = this.pageList;
        synchronized (list) {
            this.pageList.add(dcfPage);
            return this.pageList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPage(int pageIndex, DcfPage dcfPage) throws Exception {
        if (dcfPage == null) {
            throw new Exception("\u30d6\u30c3\u30af\u306bNULL\u306f\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        List<DcfPage> list = this.pageList;
        synchronized (list) {
            this.pageList.add(pageIndex, dcfPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePage(int pageIndex) {
        List<DcfPage> list = this.pageList;
        synchronized (list) {
            this.pageList.remove(pageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(DcfPageReader bookReader) throws Exception {
        List<DcfPage> list = this.pageList;
        synchronized (list) {
            int i = 0;
            while (i < bookReader.getPageCount()) {
                DcfPage dcfPage = bookReader.getPage(i);
                this.addPage(dcfPage);
                ++i;
            }
            if (bookReader instanceof DcfBook) {
                DcfBook dcfBook = (DcfBook)bookReader;
                Set<Map.Entry<String, DcfPage>> mapEntrySet = dcfBook.bgPageMap.entrySet();
                for (Map.Entry<String, DcfPage> mapEntry : mapEntrySet) {
                    this.bgPageMap.put(mapEntry.getKey(), mapEntry.getValue());
                }
            }
        }
    }

    @Override
    public DcfPage getPage(int pageIndex) throws Exception {
        return this.pageList.get(pageIndex);
    }

    @Override
    public int getPageCount() {
        return this.pageList.size();
    }

    @Override
    public boolean isBgPageEnabled() {
        return this.bgPageEnabled;
    }

    @Override
    public void setBgPageEnabled(boolean bgPageEnabled) throws Exception {
        this.bgPageEnabled = bgPageEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addBgPage(String pageName, DcfPage dcfPage) throws Exception {
        List<DcfPage> list = this.pageList;
        synchronized (list) {
            this.bgPageMap.put(pageName, dcfPage);
            return this.bgPageMap.size();
        }
    }

    @Override
    public DcfPage getBgPage(String pageName) throws Exception {
        return this.bgPageMap.get(pageName);
    }

    @Override
    public void close() throws Exception {
    }

    public DcfOutlineNode getOutlineNode(String index) {
        return this.getOutlineNodeL2(this.rootNode, index);
    }

    protected DcfOutlineNode getOutlineNodeL2(DcfOutlineNode node, String index) {
        if (node.index != null && node.index.equals(index)) {
            return node;
        }
        DcfOutlineNode resNode = null;
        int i = 0;
        while (i < node.getChildCount()) {
            DcfOutlineNode node2 = (DcfOutlineNode)node.getChildAt(i);
            resNode = this.getOutlineNodeL2(node2, index);
            if (resNode != null) break;
            ++i;
        }
        return resNode;
    }
}

