/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcCloneUtil;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.client.RmiLocalAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgTextArea;
import ext.lib.swg.SwgUtil;
import ext.lib.task.Z_TskTaskScheduler;
import ext.scf.client.ScfClientContainer;
import ext.scf3.client.ScfTableLoadEventHandler;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf3.stub.ScfDatabaseStub;
import ext.scf4.client.ScfOnlineTableModel;
import ext.scf4.client.ScfStandAloneHelper;
import ext.scf4.client.ScfTableLoadOnlineTask;
import ext.scf4.swg.HswgTableDisplayUtil;
import ext.scf4.table.ScfColumnContext;
import ext.scf4.table.ScfDisplayContext;
import ext.scf5.swg.IswgTableControlPanel3;
import ext.scf5.swg.IswgTablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javax.swing.JScrollPane;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;

public class IswgLoadableTablePanel
extends IswgTablePanel
implements ScfTableLoadEventHandler {
    private static final long serialVersionUID = 3882513288409357969L;
    private ScfTableLoadTask tableLoadTask;
    private boolean isLocal;
    private boolean isOnLine;
    protected boolean visualSaveEnavled = false;
    protected int preFromIndex = -1;
    protected int preToIndex = -1;
    protected FxLabel searchingLabel;
    protected FxButton cancelButton;
    private RmiRequest rmiReqOnShown;
    protected EventHandler<ActionEvent> fxActionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent ev) {
            try {
                IswgLoadableTablePanel.this.searchingLabel.setText(BcWords.getInstance().canceling);
                IswgLoadableTablePanel.this.cancelButton.setDisable(true);
                IswgLoadableTablePanel.this.tableLoadTask.cancel(this);
            }
            catch (Exception ex) {
                IswgLoadableTablePanel.this.handleException(ex);
            }
        }
    };

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnline(boolean isOnLine) {
        this.isOnLine = isOnLine;
    }

    public void doLoad(RmiRequest rmiReq) throws Exception {
        this.getTableLoadTask().init();
        this.tableLoadTask.setRequest(rmiReq);
        Z_TskTaskScheduler.getInstance().startTask(this.tableLoadTask);
        this.tableControlPanel.setOriginalRequest(BcCloneUtil.createClone(rmiReq));
    }

    public void doLoad2(RmiRespons rmiRes) throws Exception {
        this.getTableLoadTask().init();
        this.tableLoadTask.setHandleRespons1(rmiRes);
        Z_TskTaskScheduler.getInstance().startTask(this.tableLoadTask);
    }

    public void doLoad(String datasourceName, Object query) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, query);
        this.doLoad(rmiReq);
    }

    protected ScfTableLoadTask getTableLoadTask() throws Exception {
        if (this.tableLoadTask == null) {
            this.tableLoadTask = this.createTableLoadTask();
        }
        return this.tableLoadTask;
    }

    protected ScfTableLoadTask createTableLoadTask() throws Exception {
        RmiLocalAgent localAgent = ScfStandAloneHelper.getInstance().getLocalAgent(ScfClientContainer.getInstance().getAgent(), this.isLocal());
        ScfTableLoadTask tableLoadTask = null;
        tableLoadTask = this.isOnLine() ? new ScfTableLoadOnlineTask() : new ScfTableLoadTask();
        tableLoadTask.setLocalAgent(localAgent);
        tableLoadTask.getEventListenerList().add(ScfTableLoadEventHandler.class, this);
        tableLoadTask.getEventListenerList().add(ScfTableLoadEventHandler.class, this.tableControlPanel);
        return tableLoadTask;
    }

    protected BcTableModel createTableModel() throws Exception {
        BcTableModel tableModel = null;
        if (this.tableLoadTask instanceof ScfTableLoadOnlineTask) {
            ScfOnlineTableModel onlineTableModel = new ScfOnlineTableModel();
            onlineTableModel.setLocalAgent(this.getTableLoadTask().getLocalAgent());
            tableModel = onlineTableModel;
        } else {
            tableModel = new BcTableModel();
        }
        return tableModel;
    }

    @Override
    protected void tableMouseReleased(MouseEvent ev) throws Exception {
        super.tableMouseReleased(ev);
        if (ev.getSource() instanceof JTableHeader && this.preToIndex >= 0) {
            this.columnChanged();
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent ev) {
        super.columnMoved(ev);
        try {
            if (this.preFromIndex >= 0 && this.preFromIndex != ev.getFromIndex() && ev.getFromIndex() == ev.getToIndex()) {
                this.columnChanged();
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        this.preFromIndex = ev.getFromIndex();
        this.preToIndex = ev.getToIndex();
    }

    @Override
    protected void setPogressIndicator_L3(Pane pane) throws Exception {
        super.setPogressIndicator_L3(pane);
        this.searchingLabel = new FxLabel(BcWords.getInstance().searching);
        FxUtil.setFont((Node)this.searchingLabel, FxFontUtil.font_12_black);
        pane.getChildren().addAll((Object[])new Node[]{this.searchingLabel});
        this.cancelButton = new FxButton(BcWords.getInstance().cancel);
        this.cancelButton.setGraphic((Node)FxImageHelper.createImageView_icon("sign_forbidden_64x64.png"));
        this.cancelButton.setOnAction(this.fxActionEventHandler);
        pane.getChildren().addAll((Object[])new Node[]{this.cancelButton});
    }

    public boolean isVisualSaveEnavled() throws Exception {
        return this.visualSaveEnavled;
    }

    public void setVisualSaveEnavled(boolean visualSaveEnavled) throws Exception {
        this.visualSaveEnavled = visualSaveEnavled;
        this.tableControlPanel.setDisplaySettingButton(visualSaveEnavled);
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            if (this.tableLoadTask != null) {
                this.tableLoadTask.cancel(this);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        this.setPogressIndicator();
    }

    @Override
    public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        BcTableModel tableModel = this.createTableModel();
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        BcTableUtil.addTableColumn(tableColumnModel, tableColumnList);
        SwgTableViewUtil.setEditable(tableColumnModel, false);
        this.setTableModel(tableModel);
        SwgTableView tableView = this.createTableView();
        this.setTableView(tableView);
        this.setTableContext(tableContext);
        if (tableLoadTask instanceof ScfTableLoadOnlineTask) {
            ScfTableLoadOnlineTask tableLoadOnlineTask = (ScfTableLoadOnlineTask)tableLoadTask;
            ScfOnlineTableModel onlineTableModel = (ScfOnlineTableModel)tableModel;
            onlineTableModel.setHandleId(tableLoadTask.getHandleId());
            onlineTableModel.setRowCount(rowCount);
            tableLoadOnlineTask.setOnlineTableModel(onlineTableModel);
        }
        if (this.visualSaveEnavled) {
            this.columnSetting();
        }
    }

    @Override
    public void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
        if (tableLoadTask instanceof ScfTableLoadOnlineTask) {
            ScfTableLoadOnlineTask tableLoadOnlineTask = (ScfTableLoadOnlineTask)tableLoadTask;
            BcTableModel tableModel = this.getTableModel();
            ScfOnlineTableModel onlineTableModel = (ScfOnlineTableModel)tableModel;
            onlineTableModel.setLows(tableLoadOnlineTask.getRowNumberList(), rowList);
        } else {
            BcTableModel tableModel = this.getTableModel();
            tableModel.addRowList(rowList);
        }
    }

    @Override
    public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
    }

    @Override
    public void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowCount, int loadedRowCount) throws Exception {
    }

    @Override
    public void generalResultReceived(ScfTableLoadTask tableLoadTask, Object generalResult) throws Exception {
        Component messageComponent = SwgUtil.createMessageComponent(BcWords.getInstance().information, generalResult);
        this.setMainContent(messageComponent);
    }

    @Override
    public void cancelStarted(ScfTableLoadTask tableLoadTask, Object source) throws Exception {
    }

    @Override
    public void canceled(ScfTableLoadTask tableLoadTask) throws Exception {
        SwgTextArea txetArea = new SwgTextArea();
        txetArea.setEditable(false);
        txetArea.setForeground(Color.RED);
        txetArea.setText("Statement was canceled.");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(txetArea);
        this.setMainContent(scrollPane);
    }

    @Override
    public void tableLoadError(ScfTableLoadTask tableLoadTask, Throwable throwable) {
        BcLogUtil.error(throwable);
        Component messageComponent = SwgUtil.createMessageComponent(BcWords.getInstance().error, throwable);
        this.setMainContent(messageComponent);
    }

    @Override
    public IswgTableControlPanel3 createControlPanel() throws Exception {
        IswgTableControlPanel3 tableControlPanel = super.createControlPanel();
        tableControlPanel.setRefreshButton();
        tableControlPanel.setCancelButton();
        return tableControlPanel;
    }

    public RmiRequest getRequestOnShown() throws Exception {
        return this.rmiReqOnShown;
    }

    public void setRequestOnShown(RmiRequest rmiReq) throws Exception {
        this.rmiReqOnShown = rmiReq;
    }

    public void setRequestOnShown(String datasourceName, Object query) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, query);
        this.setRequestOnShown(rmiReq);
    }

    @Override
    protected void componentShownFirst(ComponentEvent ev) throws Exception {
        super.componentShownFirst(ev);
        if (this.rmiReqOnShown != null) {
            this.doLoad(this.rmiReqOnShown);
        }
    }

    public void columnSetting() throws Exception {
        if (BcStringUtil.isEmpty(this.getTableContext().title)) {
            return;
        }
        try {
            BcTableColumnModel tableColumnModel = this.getTableModel().getTableColumnModel();
            List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.createColumnContextList(tableColumnModel);
            this.tableControlPanel.displayContextOrigin = new ScfDisplayContext();
            this.tableControlPanel.displayContextOrigin.columnContextMap = HswgTableDisplayUtil.toMap(columnContextList);
            File xmlFile = HswgTableDisplayUtil.findXmlFile(this.getTableContext().title);
            if (xmlFile.exists()) {
                ScfDisplayContext displayContext2 = HswgTableDisplayUtil.parseXml(xmlFile);
                HswgTableDisplayUtil.applyDisplayContext(this.getTableView(), displayContext2);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            String msg = "\u5217\u9806\u4f4d\u8a2d\u5b9a\u306b\u304a\u3044\u3066\u4f8b\u5916" + ex.getMessage();
            SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
        }
    }

    public void columnChanged() throws Exception {
        if (this.visualSaveEnavled && !BcStringUtil.isEmpty(this.getTableContext().title)) {
            List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.createColumnContextList(this.getTableModel().getTableColumnModel());
            ScfDisplayContext displayContextNew = new ScfDisplayContext();
            displayContextNew.columnContextMap = HswgTableDisplayUtil.toMap(columnContextList);
            HswgTableDisplayUtil.save(this.getTableContext().title, displayContextNew, this.tableControlPanel.displayContextOrigin);
        }
    }
}

