/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.util;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileFilter;
import ext.base.io.BcFileUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public final class ScfFileUtil {
    public static final int LIST_MODE_ALL = 0;
    public static final int LIST_MODE_DIRECTRY = 1;
    public static final int LIST_MODE_FILE = 2;
    public static final int LIST_MODE_MASK = 3;
    public static final String CN_fileName = "fileName";
    public static final String CN_isDir = "isDir";
    public static final String CN_size = "dataSize";
    public static final String CN_lastModified = "lastModified";
    public static final String CN_canRead = "canRead";
    public static final String CN_canWrite = "canWrite";
    public static final String CN_isHidden = "isHidden";

    private ScfFileUtil() {
    }

    public static BcTableModel fileListToTableModel(File file1, int mode) {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        if (!file1.isDirectory()) {
            return tableModel;
        }
        BcFileFilter fileFilter = new BcFileFilter();
        fileFilter.addAcceptPattern(".*");
        if (tableColumnModel == null) {
            tableColumnModel = new BcTableColumnModel();
        }
        ScfFileUtil.createFileListTableColumnModel(tableColumnModel);
        File[] files = file1.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            File file2 = files[i];
            if ((mode != 2 || file2.isFile()) && (mode != 1 || file2.isDirectory())) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(file2.getName());
                row.add(new Boolean(file2.isDirectory()));
                if (file2.isDirectory()) {
                    if (file2.listFiles() != null) {
                        row.add(new Long(file2.listFiles().length));
                    } else {
                        row.add(new Long(0L));
                    }
                } else {
                    row.add(new Long(file2.length()));
                }
                Calendar calendar = BcTimeUtil.createCalendar();
                calendar.setTimeInMillis(file2.lastModified());
                row.add(calendar);
                row.add(new Boolean(file2.canRead()));
                row.add(new Boolean(file2.canWrite()));
                row.add(new Boolean(file2.isHidden()));
                tableModel.addRow(row);
            }
            ++i;
        }
        return tableModel;
    }

    protected static void createFileListTableColumnModel(BcTableColumnModel tableColumnModel) {
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_fileName;
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("file name");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_isDir;
        mmdField.dataClass = Boolean.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("dir");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_size;
        mmdField.dataClass = Long.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue(CN_size);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_lastModified;
        mmdField.dataClass = Timestamp.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("last modified");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_canRead;
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("read");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_canWrite;
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("write");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = CN_isHidden;
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("hidden");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
    }

    public static String createFilePath(String baseName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(AfbApplication.getInstance().toReal("${APP}export/"));
        sb.append(baseName);
        sb.append("_");
        sb.append(BcFileUtil.create_yyyyMMdd_HHmmssSSS());
        sb.append(".csv");
        return sb.toString();
    }
}

