/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xupd.client;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbConstants;
import ext.base.core.BcBooleanUtil;
import ext.base.core.BcInteger;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.xml.BcXmlUtil;
import ext.lib.ant.AntUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.http.client.HtclContentLoader;
import ext.module.xupd.common.XupdUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XupdChacker {
    public int check(BcMonitor parentMonitor) throws Exception {
        if (parentMonitor != null) {
            parentMonitor.lock();
        }
        int exitCode = this.check_L2();
        if (parentMonitor != null) {
            parentMonitor.unLock();
        }
        return exitCode;
    }

    protected int check_L2() throws Exception {
        final BcInteger exitCode = new BcInteger(AfbConstants.ExitCode.OK.code);
        Document bootConfig = AfbApplication.getInstance().getBootConfig();
        Node updateAntTaskNode = BcXmlUtil.getNode(bootConfig, "updateAntTask");
        if (updateAntTaskNode == null) {
            return exitCode.value;
        }
        ByteArrayOutputStream baos = this.loadAntXml(updateAntTaskNode);
        if (baos == null || baos.size() <= 0) {
            return exitCode.value;
        }
        Document antDom = XupdUtil.createAntDom(baos.toByteArray(), false);
        String enabled = AntUtil.getPropertyValue(antDom, "enabled");
        if (!BcBooleanUtil.parseBoolean(enabled).booleanValue()) {
            BcLogUtil.debug("\u66f4\u65b0\u60c5\u5831\u306f\u3042\u308b\u304c\u7121\u52b9\u306e\u305f\u3081\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u307e\u305b\u3093\u3002");
            return exitCode.value;
        }
        final String confirmTitle = AntUtil.getPropertyValue(antDom, "confirmTitle");
        final String confirmMessage = AntUtil.getPropertyValue(antDom, "confirmMessage");
        final BcMonitor monitor = new BcMonitor();
        monitor.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                if (FxOptionPane.showConfirmDialog(confirmMessage, confirmTitle, 3) == 0) {
                    exitCode.value = 21;
                }
                monitor.unLock();
            }
        });
        monitor.sync();
        if (exitCode.value == 21) {
            File destFile = XupdUtil.getAntFile1();
            BcLogUtil.debug("destFile=" + destFile);
            BcFileUtil.deleteIfExists(destFile);
            BcXmlUtil.output(antDom, destFile, true);
        }
        return exitCode.value;
    }

    protected ByteArrayOutputStream loadAntXml(Node updateAntTaskNode) throws Exception {
        ByteArrayOutputStream baos = null;
        Node urlListNode = BcXmlUtil.getNode(updateAntTaskNode, "urlList");
        if (urlListNode == null) {
            return baos;
        }
        List<Node> urlNodeList = BcXmlUtil.getNodeList(urlListNode, "url");
        HtclContentLoader contentLoader = new HtclContentLoader();
        int i = 0;
        while (i < urlNodeList.size()) {
            Node urlNode = urlNodeList.get(i);
            try {
                URL url = new URL(BcXmlUtil.getTextValue(urlNode));
                BcLogUtil.debug("url=" + url);
                baos = contentLoader.getContent(url);
                break;
            }
            catch (ConnectException url) {
            }
            catch (UnknownHostException url) {
            }
            catch (SocketTimeoutException url) {
            }
            catch (Exception ex) {
                throw ex;
            }
            ++i;
        }
        return baos;
    }
}

