/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.fx;

import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsLicensePane
extends FxDecoratePane {
    public FxTextArea textArea = new FxTextArea();
    Button agreementButton;
    Button refusalButton;
    boolean isAgreement;
    Stage stage;

    public XdtsLicensePane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.textArea.setEditable(false);
        this.setCenter((Node)this.textArea);
        this.agreementButton = FxUtil.createOkButton(BcWords.getInstance().agreement, null);
        this.agreementButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.agreementButton);
        this.refusalButton = FxUtil.createCancelButton(BcWords.getInstance().refusal, null);
        this.refusalButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.refusalButton);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.agreementButton) {
            this.isAgreement = true;
            this.close();
        } else if (ev.getSource() == this.refusalButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public boolean show(Window ownerWindow) throws Exception {
        this.isAgreement = false;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsLicensePane.this.agreementButton.requestFocus();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(640.0);
        this.stage.setHeight(600.0);
        this.stage.setResizable(false);
        this.stage.setTitle(BcWords.getInstance().licenseAgreement);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.toFront();
        this.stage.showAndWait();
        return this.isAgreement;
    }
}

