/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import ext.lib.swg.SwgTableCellEditor;
import ext.module.xfil.common.HashtagUtil;
import ext.module.xfil.common.XfilTagUtil;
import ext.module.xfil.stub.XfilUriEntityStub;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

class XfilTagCellEditor
extends SwgTableCellEditor {
    int columnId_entityId;

    @Override
    public Component getTableCellEditorComponent(JTable tableView, Object value, boolean isSelected, int rowIndex, int columnIndex) {
        try {
            String tmpStr = BcStringUtil.toStringNotNull(value);
            if (tmpStr.startsWith(XfilTagUtil.delimiter)) {
                tmpStr = tmpStr.substring(XfilTagUtil.delimiter.length());
            }
            if (tmpStr.endsWith(XfilTagUtil.delimiter)) {
                tmpStr = tmpStr.substring(0, tmpStr.length() - XfilTagUtil.delimiter.length());
            }
            value = tmpStr;
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return super.getTableCellEditorComponent(tableView, value, isSelected, rowIndex, columnIndex);
    }

    @Override
    public Object getCellEditorValue() {
        String res = null;
        try {
            Object tmpValue = super.getCellEditorValue();
            String tmpStr = BcStringUtil.toStringNotNull(tmpValue);
            BcLogUtil.debug("getCellEditorValue:tmpValue=" + tmpValue + " tmpStr=" + tmpStr);
            List<String> valueList1 = BcCsvUtil.parseCsvRow(tmpStr, true);
            ArrayList<String> valueList2 = new ArrayList<String>();
            for (String value1 : valueList1) {
                String value2 = HashtagUtil.getInstance().removeNotAllowedCharacter(value1);
                if (BcStringUtil.isEmpty(value2)) continue;
                valueList2.add(value2);
            }
            res = XfilTagUtil.toPersistenceString(valueList2);
            try {
                BcTableModel tableModel = (BcTableModel)this.tableView.getModel();
                long entityId = (Long)tableModel.getValueAt(this.rowIndex, this.columnId_entityId);
                XfilUriEntityStub.getInstance().update(entityId, res);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return res;
    }
}

