/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgTableView;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilConditionSet;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.rmo.XfilCrawlRMO;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf5.swg.IswgAbstractDataViewPanel;
import ext.scf5.swg.IswgLoadableTablePanel;
import ext.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.event.ListSelectionEvent;

public class XfilCrawlListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    public XfilCrawlListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().crawlList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionSet.initCrawlerUnit(false, null);
        conditionPane.addNodeUnit(conditionSet.crawlerUnit);
        conditionPane.addNodeUnit(conditionSet.keywordUnit);
        conditionPane.addNodeUnit(conditionSet.crawlStartPeriodUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilAnalysisCondition analysisCondition = conditionPane.conditionSet.getCondition();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilCrawlRMO.class.getName());
        rmiReq.setMethodName(XfilCrawlRMO.Method.list.getMethodName());
        rmiReq.addData(analysisCondition);
        return rmiReq;
    }

    @Override
    protected IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    public void sercByCrawlerId(final long crawlerId) throws Exception {
        final InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    conditionPane.conditionSet.setCrawlerId(crawlerId);
                    XfilCrawlListPanel.this.doSearch();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;

        public InnerTablePanel() throws Exception {
            this.setVisualSaveEnavled(true);
        }

        @Override
        public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
            super.tableColumnReceived(tableLoadTask, tableColumnList, rowSize, tableContext);
        }

        @Override
        protected SwgTableView createTableView() throws Exception {
            SwgTableView tableView = super.createTableView();
            return tableView;
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
            XfilFxHelper.getInstance().openCrawlerPane(this.entityId.longValue());
        }
    }
}

