/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.appfw.common.AfbConstants;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcProcessExecutor;
import ext.lib.awt.AwtImageUtil;
import ext.module.xfil.common.FfpegParam;
import ext.module.xfil.common.FfpegText;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.model.MovieInfo;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVideoCaptureParameter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class XfilVideoCaptureHelper
extends BcLoggableObject {
    public void proc1(XfilUriEntity uriEntity, XfilVideoCaptureParameter videoCaptureParam1, File dir) throws Exception {
        File imputFile = XfilUtil.toFile(uriEntity);
        this.getLogger().info("imputFile=" + imputFile.getPath());
        if (imputFile.exists()) {
            try {
                this.proc2(uriEntity, imputFile, videoCaptureParam1, dir);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                uriEntity.error2 = ex.getMessage();
            }
        } else {
            this.getLogger().warning("Not found file:" + imputFile.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
        uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
    }

    protected void proc2(XfilUriEntity uriEntity, File imputFile, XfilVideoCaptureParameter videoCaptureParameter1, File dir) throws Exception {
        MovieInfo movieInfo = XfilUtil.setMovieInfo(uriEntity, imputFile);
        if (uriEntity.durationMillis <= 0L) {
            uriEntity.error2 = "duration=" + uriEntity.durationMillis;
            this.getLogger().debug("uriEntity.error1=" + uriEntity.error1);
            return;
        }
        XfilVideoCaptureParameter videoCaptureParameter2 = XfilCaptureUtil.adjustment(videoCaptureParameter1, movieInfo);
        ArrayList<Long> startTimeMillisList = new ArrayList<Long>();
        int i = 0;
        while (i < videoCaptureParameter2.capturingCount) {
            long startTimeMillis = videoCaptureParameter2.headMargin + videoCaptureParameter2.interval * (long)i;
            startTimeMillisList.add(startTimeMillis);
            ++i;
        }
        this.getLogger().debug("startTimeMillisList.size()=" + startTimeMillisList.size());
        XfilUtil.deleteTthumbnails(uriEntity);
        Object[] res = this.proc2_L2(uriEntity, imputFile, videoCaptureParameter2, startTimeMillisList, dir);
        List fileList = (List)res[0];
        uriEntity.error2 = (String)res[1];
        if (videoCaptureParameter2.width <= XfilConstants.thumbnailResolution.width || videoCaptureParameter2.height <= XfilConstants.thumbnailResolution.height) {
            uriEntity.thumbnailFiles = this.toFileNameCsv(fileList);
        } else {
            uriEntity.imageFiles = this.toFileNameCsv(fileList);
            ArrayList<String> fileNameList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < fileList.size()) {
                File file = (File)fileList.get(i2);
                long startTimeMillis = (Long)startTimeMillisList.get(i2);
                BufferedImage bufferedImage1 = AwtImageUtil.loadImage(file);
                BufferedImage bufferedImage2 = AwtImageUtil.resizeImage(bufferedImage1, XfilConstants.thumbnailResolution.width, XfilConstants.thumbnailResolution.height);
                String extention = AwtImageUtil.ImageFileType.JPG.extentions[0];
                String fileName = XfilUtil.createFileName(startTimeMillis, XfilConstants.thumbnailResolution.width, XfilConstants.thumbnailResolution.height, uriEntity.id, extention, imputFile.getName());
                File destFile = new File(dir, fileName);
                AwtImageUtil.outputImageJpg(bufferedImage2, destFile, 1.0f);
                fileNameList.add(fileName);
                ++i2;
            }
            uriEntity.thumbnailFiles = BcCsvUtil.toCsv(fileNameList);
        }
    }

    protected Object[] proc2_L2(XfilUriEntity uriEntity, File imputFile, XfilVideoCaptureParameter videoCaptureParameter, List<Long> startTimeMillisList, File dir) throws Exception {
        ArrayList fileList1 = new ArrayList();
        BcProcessExecutor.BcProcessResult processResultErr = null;
        int i = 0;
        while (i < startTimeMillisList.size()) {
            Long startTimeMillis = startTimeMillisList.get(i);
            String extention = AwtImageUtil.ImageFileType.JPG.extentions[0];
            String fileName = XfilUtil.createFileName(startTimeMillis, videoCaptureParameter.width, videoCaptureParameter.height, uriEntity.id, extention, imputFile.getName());
            File outputFile = new File(dir, fileName);
            this.getLogger().debug("outputFile=" + outputFile.getPath());
            BcFileUtil.makeParent(outputFile);
            BcFileUtil.deleteIfExists(outputFile);
            Object[] res = this.executeFfmpeg(uriEntity, imputFile, startTimeMillis, videoCaptureParameter, outputFile.getPath());
            BcProcessExecutor.BcProcessResult processResult = (BcProcessExecutor.BcProcessResult)res[0];
            if (processResult.exitValue != AfbConstants.ExitCode.OK.code) {
                processResultErr = processResult;
                break;
            }
            List fileList2 = (List)res[1];
            if (fileList2 != null) {
                fileList1.addAll(fileList2);
            }
            ++i;
        }
        String err = null;
        if (processResultErr != null) {
            err = processResultErr.out;
        }
        Object[] res = new Object[]{fileList1, err};
        return res;
    }

    protected String toFileNameCsv(List<File> fileList) throws Exception {
        if (BcCollectionUtil.isEmpty(fileList)) {
            return null;
        }
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (File file : fileList) {
            fileNameList.add(file.getName());
        }
        return BcCsvUtil.toCsv(fileNameList);
    }

    public Object[] executeFfmpeg(XfilUriEntity uriEntity, File imputFile, long startTimeMillis, XfilVideoCaptureParameter videoCaptureParam, String outputPath) throws Exception {
        FfpegParam ffpegParam = new FfpegParam();
        ffpegParam.inputPath = imputFile.getPath();
        ffpegParam.outputPath = outputPath;
        ffpegParam.startTimeMillis = startTimeMillis;
        if (videoCaptureParam.elapsedTime) {
            ffpegParam.ffpegTextList = new ArrayList<FfpegText>();
            FfpegText ffpegText = new FfpegText();
            int margin = 10;
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 0) {
                ffpegText.x = "(w-tw)/2";
            }
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 2) {
                ffpegText.x = String.valueOf(margin);
            }
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 4) {
                ffpegText.x = "w-tw-" + margin;
            }
            if (videoCaptureParam.elapsedTimeVerticalPositionId == 0) {
                ffpegText.y = "(h-th)/2";
            } else if (videoCaptureParam.elapsedTimeVerticalPositionId == 1) {
                ffpegText.y = String.valueOf(margin);
            } else if (videoCaptureParam.elapsedTimeVerticalPositionId == 3) {
                ffpegText.y = "h-th-" + margin;
            }
            ffpegText.fontSize = 20;
            ffpegText.fontColor = Color.WHITE;
            ffpegText.text = BcTimeUtil.toDurationString(ffpegParam.startTimeMillis);
            ffpegText.text = ffpegText.text.replace(":", "\\:");
            ffpegText.borderw = 1;
            ffpegText.borderColor = Color.BLACK;
            ffpegParam.ffpegTextList.add(ffpegText);
        }
        XfilCaptureUtil.setParam(videoCaptureParam, ffpegParam);
        return XfilCaptureUtil.executeFfmpeg(ffpegParam);
    }
}

