/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.nlp.NlpElement;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpNounFinderImpl;
import ext.lib.nlp.NlpResult;
import ext.lib.task.TskAbstractCallable;
import ext.libx.etc.util.EtcLockManger;
import ext.module.xfil.common.HashtagUtil;
import ext.module.xfil.common.XfilTagUtil;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.server.XfilServerUtil;
import java.util.ArrayList;
import java.util.concurrent.Future;

public class XfilTagCreateTask
extends TskAbstractCallable {
    public Future future;
    public DtsSession dtsSessionWk;
    public XfilUriEntityDAO uriEntityDao;
    NlpNounFinderImpl nounFinder;

    public Object taskProcess() throws Exception {
        long exceptEntityId = -1L;
        while (true) {
            XfilUriEntity uriEntity;
            if ((uriEntity = (XfilUriEntity)this.uriEntityDao.getForTag(this.dtsSessionWk, -1L, exceptEntityId)) == null) {
                Thread.sleep(3000L);
                exceptEntityId = -1L;
                continue;
            }
            XfilUriEntity preEntity = EtcLockManger.getInstance().check(uriEntity, uriEntity.id);
            if (preEntity == null) {
                block9: {
                    try {
                        try {
                            this.createTag(uriEntity);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex);
                            EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                        throw throwable;
                    }
                    EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                }
                exceptEntityId = -1L;
            } else {
                exceptEntityId = preEntity.id;
            }
            this.getLogger().info(null);
        }
    }

    protected void createTag(XfilUriEntity uriEntity) throws Exception {
        this.getLogger().info("createTag:uriEntity.name=" + uriEntity.name);
        this.nounFinder = XfilServerUtil.getInstance().getNounFinder();
        NlpResult nlpResult = this.nounFinder.find(uriEntity.name);
        ArrayList<String> tagList = new ArrayList<String>();
        int i = 0;
        while (i < nlpResult.elementList.size()) {
            NlpElement nlpElement = nlpResult.elementList.get(i);
            NlpNoun noun = nlpElement.noun;
            String tag = HashtagUtil.getInstance().removeNotAllowedCharacter(noun.key);
            if (!BcStringUtil.isEmpty(tag)) {
                tagList.add(tag);
            }
            ++i;
        }
        uriEntity.tag = BcCollectionUtil.isEmpty(tagList) ? XfilTagUtil.EMPTY : XfilTagUtil.toPersistenceString(tagList);
        boolean fileExists = XfilServerUtil.getInstance().checkFileExists(uriEntity);
        this.uriEntityDao.putEntity(this.dtsSessionWk, uriEntity);
        this.dtsSessionWk.commit();
    }
}

