/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.EtcSqlUtil;
import ext.lib.task.TskAbstractCallable;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.dao.XfilCrawlDAO;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilCrawler;
import ext.module.xfil.model.XfilVideoCaptureParameter;
import ext.module.xfil.server.XfilServerUtil;
import ext.module.xfil.server.XfilVisitFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;

public class XfilFileCrawlTask
extends TskAbstractCallable {
    public Future future;
    public DtsSession dtsSessionWk;
    public XfilUriEntityDAO uriEntitydao;
    public XfilCrawler crawler;
    public XfilCrawl crawl;
    public List<String> fileExtentionList;
    public List<String> exclusionPathList;
    public XfilVideoCaptureParameter videoCaptureParameter;
    public String note = null;
    int maxDepth = Integer.MAX_VALUE;
    XfilVisitFile visitFile;
    FileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
            XfilFileCrawlTask.this.getLogger().info("Directory:=" + path);
            if (path.toFile().getName().equalsIgnoreCase("$RECYCLE.BIN")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            try {
                fileVisitResult = XfilFileCrawlTask.this.visitFile.visitFile(path, XfilFileCrawlTask.this.dtsSessionWk, XfilFileCrawlTask.this.uriEntitydao, XfilFileCrawlTask.this.crawler.overwrirte, XfilFileCrawlTask.this.fileExtentionList, XfilFileCrawlTask.this.crawler.indexGroupId, XfilFileCrawlTask.this.crawl, XfilFileCrawlTask.this.videoCaptureParameter, XfilFileCrawlTask.this.note, XfilFileCrawlTask.this.exclusionPathList);
                XfilFileCrawlTask.this.dtsSessionWk.commit();
            }
            catch (Exception ex) {
                XfilFileCrawlTask.this.getLogger().error(ex);
            }
            return fileVisitResult;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            try {
                fileVisitResult = XfilFileCrawlTask.this.visitFile.visitFile(path, XfilFileCrawlTask.this.dtsSessionWk, XfilFileCrawlTask.this.uriEntitydao, XfilFileCrawlTask.this.crawler.overwrirte, XfilFileCrawlTask.this.fileExtentionList, XfilFileCrawlTask.this.crawler.indexGroupId, XfilFileCrawlTask.this.crawl, XfilFileCrawlTask.this.videoCaptureParameter, XfilFileCrawlTask.this.note, XfilFileCrawlTask.this.exclusionPathList);
                XfilFileCrawlTask.this.dtsSessionWk.commit();
            }
            catch (Exception ex) {
                XfilFileCrawlTask.this.getLogger().error(ex);
            }
            return fileVisitResult;
        }
    };

    public Object taskProcess() throws Exception {
        this.visitFile = new XfilVisitFile();
        this.visitFile.setLogger(this.getLogger());
        try {
            this.crawl.startTimestamp = BcTimeUtil.createCalendar();
            this.crawl.statusId = XfilConstants.CrawlStatus.processing.id;
            if (this.crawl.id > 0L) {
                XfilCrawlDAO.getInstance().putEntity(this.dtsSessionWk, this.crawl);
                this.dtsSessionWk.commit();
            }
            List<String> targetPathList = BcStringUtil.lineSeparete(this.crawler.targetPath);
            this.exclusionPathList = BcStringUtil.lineSeparete(this.crawler.exclusionPath);
            for (String pathStr : targetPathList) {
                File file = new File(pathStr);
                this.getLogger().debug("file=" + file.getPath());
                if (!file.exists()) continue;
                this.taskProcess_L2(file.toPath());
            }
            this.crawl.endTimestamp = BcTimeUtil.createCalendar();
            this.crawl.statusId = XfilConstants.CrawlStatus.completed.id;
            if (this.crawl.id > 0L) {
                XfilServerUtil.getInstance().setSummary(this.dtsSessionWk, this.crawl);
                XfilCrawlDAO.getInstance().putEntity(this.dtsSessionWk, this.crawl);
                this.dtsSessionWk.commit();
            }
        }
        finally {
            EtcSqlUtil.closeSession(this.dtsSessionWk, this.getLogger());
        }
        this.getLogger().info(null);
        this.future = null;
        return null;
    }

    protected void taskProcess_L2(Path path) throws Exception {
        EnumSet<FileVisitOption> fileVisitOptionSet = EnumSet.allOf(FileVisitOption.class);
        Files.walkFileTree(path, fileVisitOptionSet, this.maxDepth, this.fileVisitor);
    }
}

