/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.dao.XfilIndexGroupDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilIndexGroup;
import ext.module.xfil.server.XfilServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfQueryTask;
import java.util.ArrayList;
import java.util.List;

public class XfilIndexGroupRMO
extends RmiAbstractRMO<XfilIndexGroup> {
    String tableName = XfilConstants.TableName.xfil_index_group.name();

    public void put(RmiRmoArgument rmoArg) throws Exception {
        XfilIndexGroup indexGroup1 = (XfilIndexGroup)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilIndexGroup entity2 = null;
            if (indexGroup1.id <= 0L) {
                entity2 = indexGroup1;
            } else {
                entity2 = (XfilIndexGroup)XfilIndexGroupDAO.getInstance().getById(dtsSessionWk, indexGroup1.id);
                entity2.name = indexGroup1.name;
                entity2.note = indexGroup1.note;
            }
            XfilIndexGroupDAO.getInstance().putEntity(dtsSessionWk, entity2);
            dtsSessionWk.commit();
            rmoArg.getRespons().addData(entity2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void delete(RmiRmoArgument rmoArg) throws Exception {
        long indexGroupId = rmoArg.getRequest().getDataAsLong();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            BcResult result = new BcResult();
            XfilIndexGroup indexGroup = (XfilIndexGroup)XfilIndexGroupDAO.getInstance().getById(dtsSessionWk, indexGroupId);
            result.setUserObject(result);
            if (indexGroup != null) {
                BcResult result2 = XfilServerUtil.getInstance().deleteIndexGroup(dtsSessionWk, indexGroup);
                result.addResult(result2);
            } else {
                result.addError(BcWords.getInstance().Target_object_does_not_exist);
            }
            rmoArg.getRespons().addData(result);
            dtsSessionWk.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void get(RmiRmoArgument rmoArg) throws Exception {
        long indexGroupId = rmoArg.getRequest().getDataAsLong();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilIndexGroup indexGroup = (XfilIndexGroup)XfilIndexGroupDAO.getInstance().getById(dtsSessionWk, indexGroupId);
            rmoArg.getRespons().addData(indexGroup);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getList(RmiRmoArgument rmoArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            List List2 = XfilIndexGroupDAO.getInstance().getList(dtsSessionWk, XfilIndexGroupDAO.Mode.id, 0L, null, null, 0, this.objectPoolEnabled);
            rmoArg.getRespons().addData(List2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void list(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase(selectQuery);
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlConditionParser conditionParser = XfilUtil.createConditionParser(sqlContext);
        SqlWhereElement whereElement = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".name_", String.valueOf(this.tableName) + ".name_", analysisCondition.keyword, null, false);
        if (whereElement != null) {
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.registrationPeriodStart > 0 || analysisCondition.registrationPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".add_timestamp", analysisCondition.registrationPeriodStart, analysisCondition.registrationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "name_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "note_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "add_timestamp"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "update_timestamp"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectQuery selectQuery) {
        selectQuery.getOrderByList().add(String.valueOf(this.tableName) + ".id");
    }

    public static enum Method implements RmiRemoteMethod
    {
        put,
        delete,
        get,
        getList,
        list;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

