/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcInputValidator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskManager;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.dao.XfilCrawlDAO;
import ext.module.xfil.dao.XfilCrawlerDAO;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilCrawler;
import ext.module.xfil.model.XfilFileCrawlUnit;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVideoCaptureCondition;
import ext.module.xfil.model.XfilVideoCaptureParameter;
import ext.module.xfil.server.XfilFileCrawlTask;
import ext.module.xfil.server.XfilServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfQueryTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class XfilCrawlRMO
extends RmiAbstractRMO {
    String tableName = XfilConstants.TableName.xfil_crawl.name();

    public void fileCrawl1(RmiRmoArgument rmoArg) throws Exception {
        List uriEntityList = (List)rmoArg.getRequest().getData();
        boolean overWrirte = rmoArg.getRequest().getDataAsBoolean();
        String fileExtention = rmoArg.getRequest().getDataAsString();
        XfilVideoCaptureParameter videoCaptureParameter = (XfilVideoCaptureParameter)rmoArg.getRequest().getData();
        this.getLogger().info("fileCrawl:uriEntityList.size()=" + uriEntityList.size());
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            this.getLogger().info("uriEntity.name=" + uriEntity.name);
            XfilFileCrawlUnit crawlUnit = new XfilFileCrawlUnit();
            crawlUnit.crawl = new XfilCrawl();
            crawlUnit.uriEntity = uriEntity;
            crawlUnit.overwrirte = overWrirte;
            crawlUnit.fileExtentionList = BcCsvUtil.parseCsvRow(fileExtention, false);
            crawlUnit.videoCaptureParameter = videoCaptureParameter;
            XfilServerUtil.getInstance().crawlQueue.offer(crawlUnit);
            ++i;
        }
        XfilServerUtil.getInstance().startService2();
    }

    public void fileCrawl2(RmiRmoArgument rmoArg) throws Exception {
        long entityId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);
        XfilCrawler crawler = null;
        XfilCrawl crawl = null;
        BcResult result = new BcResult();
        try {
            crawler = (XfilCrawler)XfilCrawlerDAO.getInstance().getById(dtsSessionWk, entityId);
            List processingList = XfilCrawlDAO.getInstance().getList_processing(dtsSessionWk, crawler.id);
            this.getLogger().info("fileCrawl2:processingList.size()=" + processingList.size());
            if (BcCollectionUtil.isEmpty(processingList)) {
                this.getLogger().info("fileCrawl2:crawler.id=" + crawler.id);
                crawl = new XfilCrawl();
                crawl.crawlerId = crawler.id;
                XfilCrawlDAO.getInstance().putEntity(dtsSessionWk, crawl);
                dtsSessionWk.commit();
            } else {
                String msg = BcInputValidator.getInstance().$_is_running(XfilWords.getInstance().crawlerId + "=" + crawler.id);
                result.addError(msg);
            }
        }
        catch (Exception ex) {
            dtsSessionWk.desturuct();
            throw ex;
        }
        rmoArg.getRespons().addData(result);
        if (result.hasError()) {
            return;
        }
        XfilFileCrawlTask task = new XfilFileCrawlTask();
        task.setLogger(XfilServerUtil.getInstance().createLogger("File Crawl Task"));
        task.dtsSessionWk = dtsSessionWk;
        task.uriEntitydao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        task.crawler = crawler;
        task.crawl = crawl;
        task.fileExtentionList = BcCsvUtil.parseCsvRow(crawler.fileExtention, false);
        XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.convVideoCaptureCondition(crawler);
        task.videoCaptureParameter = XfilCaptureUtil.convert(videoCaptureCondition);
        ExecutorService executorService = Executors.newCachedThreadPool();
        task.future = executorService.submit(task);
        executorService.shutdown();
        TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable)task, task.future);
        TskTaskManager.getInstance().addCallableUnit(callableUnit);
    }

    public void deleteMissing(RmiRmoArgument rmoArg) throws Exception {
        long crawlId = rmoArg.getRequest().getDataAsLong();
        this.getLogger().info("deleteCrawl:.crawlId=" + crawlId);
        BcResult result = new BcResult();
        Throwable throwable = null;
        Object var6_7 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilCrawl crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, crawlId);
            if (crawl != null) {
                XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
                long indexGroupId = -1L;
                List uriEntityList1 = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.missing, -1L, indexGroupId, crawl.id, null, null, null, -1, false, new long[0]);
                this.getLogger().info("\u6240\u5728\u4e0d\u660e\u6570=" + uriEntityList1.size());
                int i = 0;
                while (i < uriEntityList1.size()) {
                    XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList1.get(i);
                    XfilUtil.deleteTthumbnails(uriEntity);
                    int deleteCnt = uriEntityDAO.deleteByCrawlId(dtsSessionWk, crawl.id, uriEntity.id, true);
                    dtsSessionWk.commit();
                    this.getLogger().debug("deleteCnt=" + deleteCnt);
                    ++i;
                }
                dtsSessionWk.commit();
            } else {
                result.addError(BcWords.getInstance().Target_object_does_not_exist);
            }
            rmoArg.getRespons().addData(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BcResult check(DtsSession dtsSessionMain, XfilVideoCaptureParameter captureParam) throws Exception {
        BcResult result1 = new BcResult();
        BcResult result2 = XfilServerUtil.getInstance().validateCapturingCondition(dtsSessionMain);
        result1.addResult(result2);
        result2 = XfilServerUtil.getInstance().validateCapturingCondition(captureParam);
        result1.addResult(result2);
        if (result1.hasError()) {
            return result1;
        }
        return result1;
    }

    public void list(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase(selectQuery);
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (analysisCondition.crawlerId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableName) + ".crawler_id = " + analysisCondition.crawlerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.registrationPeriodStart > 0 || analysisCondition.registrationPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".add_date_time", analysisCondition.registrationPeriodStart, analysisCondition.registrationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.craw\uff4cPeriodStart > 0 || analysisCondition.craw\uff4cPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".start_timestamp", analysisCondition.craw\uff4cPeriodStart, analysisCondition.craw\uff4cPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "crawler_id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "start_timestamp"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "end_timestamp"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "status_id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "note_"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        sb.append(" LEFT JOIN xfil_crawler ON xfil_crawler.id = " + tableName + ".crawler_id");
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectQuery selectQuery) {
        selectQuery.getOrderByList().add(String.valueOf(this.tableName) + ".id");
    }

    public static enum Method implements RmiRemoteMethod
    {
        fileCrawl1,
        fileCrawl2,
        deleteMissing,
        list;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

