/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.model.XfilCrawler;
import java.util.ArrayList;
import java.util.List;

public class XfilCrawlerDAO
extends OrmAbstractDAO<XfilCrawler> {
    private XfilCrawlerDAO() {
        super(new XfilCrawler[0]);
        this.setTableName(XfilConstants.TableName.xfil_crawler.name());
    }

    public static XfilCrawlerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public int deleteEntityAll(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int cnt = sqlContext.deleteAllRow(dtsSession.getConnection(), this.tableName);
        return cnt;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long entityId, String name, int rowLimit, boolean isFuzzy) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(name)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                ArrayList<String> conditionValueList = new ArrayList<String>();
                conditionValueList.add(name);
                String formula = SqlConditionUtil.createPatternMatchClause(sqlContext, "name_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula("name_" + sqlContext.toCondition_string("=", name));
            }
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == Mode.id) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        } else if (mode == Mode.name) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        }
        selectQuery.rowLimit = rowLimit;
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long entityId, String name, int rowLimit, boolean isFuzzy) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "crawler";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, entityId, name, rowLimit, isFuzzy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getById(DtsSession dtsSession, long entityId) throws Exception {
        if (entityId <= 0L) {
            return null;
        }
        String name = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.id, entityId, name, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByName(DtsSession dtsSession, String name, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        int entityId = -1;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, name, rowLimit, isFuzzy);
        return entityList;
    }

    /* synthetic */ XfilCrawlerDAO(XfilCrawlerDAO xfilCrawlerDAO) {
        this();
    }

    public static enum Mode {
        id("id"),
        name("name_");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final XfilCrawlerDAO instance = new XfilCrawlerDAO(null);

        private SingletonHolder() {
        }
    }
}

