/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.model.XfilCrawl;
import java.util.List;

public class XfilCrawlDAO
extends OrmAbstractDAO<XfilCrawl> {
    private XfilCrawlDAO() {
        super(new XfilCrawl[0]);
        this.setTableName(XfilConstants.TableName.xfil_crawl.name());
    }

    public static XfilCrawlDAO getInstance() {
        return SingletonHolder.instance;
    }

    public int deleteEntityAll(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int cnt = sqlContext.deleteAllRow(dtsSession.getConnection(), this.tableName);
        return cnt;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long entityId, long crawlerId, int rowLimit, boolean isProcessing) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (crawlerId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("crawler_id = " + crawlerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (isProcessing) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("status_id = " + XfilConstants.CrawlStatus.processing.id);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == Mode.id) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        } else if (mode == Mode.name) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        }
        selectQuery.rowLimit = rowLimit;
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long entityId, long crawlerId, int rowLimit, boolean isFuzzy) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "crawl";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, entityId, crawlerId, rowLimit, isFuzzy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getById(DtsSession dtsSession, long entityId) throws Exception {
        if (entityId <= 0L) {
            return null;
        }
        long crawlerId = -1L;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.id, entityId, crawlerId, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getList_processing(DtsSession dtsSession, long crawlerId) throws Exception {
        long entityId = -1L;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.crawlerId, entityId, crawlerId, rowLimit, true);
        return entityList;
    }

    public int updateCanceled(DtsSession dtsSession) throws Exception {
        String query = "UPDATE " + this.getTableName() + " SET status_id = " + XfilConstants.CrawlStatus.canceled.id + " WHERE status_id = " + XfilConstants.CrawlStatus.processing.id;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ XfilCrawlDAO(XfilCrawlDAO xfilCrawlDAO) {
        this();
    }

    public static enum Mode {
        id("id"),
        crawlerId("crawler_id"),
        name("name_");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final XfilCrawlDAO instance = new XfilCrawlDAO(null);

        private SingletonHolder() {
        }
    }
}

