/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCompareUtil;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilFileCompareResult;
import ext.module.xfil.model.XfilFileCompareResultPack;
import ext.module.xfil.model.XfilUriEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XfilFileCompareUtil {
    XfilAnalysisCondition analysisCondition;
    Collection<XfilUriEntity> uriEntityCollection1;
    Collection<XfilUriEntity> uriEntityCollection2;
    Map<String, XfilUriEntity> uriEntityMap1;
    Map<String, XfilUriEntity> uriEntityMap2;
    public XfilAnalysisResult analysisResult;

    public XfilFileCompareResultPack doAnalyze(XfilAnalysisCondition analysisCondition, Collection<XfilUriEntity> uriEntityCollection1, Collection<XfilUriEntity> uriEntityCollection2) throws Exception {
        this.analysisCondition = analysisCondition;
        this.uriEntityCollection1 = uriEntityCollection1;
        this.uriEntityCollection2 = uriEntityCollection2;
        this.uriEntityMap1 = this.createMap(uriEntityCollection1);
        this.uriEntityMap2 = this.createMap(uriEntityCollection2);
        this.analysisResult = new XfilAnalysisResult();
        this.analysisResult.uriEntityMap = new HashMap<String, List<XfilUriEntity>>();
        XfilFileCompareResultPack fFileCompareResult = new XfilFileCompareResultPack();
        fFileCompareResult.result1 = this.analyze_L2(uriEntityCollection1, this.uriEntityMap2);
        fFileCompareResult.result2 = this.analyze_L2(uriEntityCollection2, this.uriEntityMap1);
        return fFileCompareResult;
    }

    protected XfilFileCompareResult analyze_L2(Collection<XfilUriEntity> uriEntityCollection, Map<String, XfilUriEntity> uriEntityMap) throws Exception {
        XfilFileCompareResult compareResult = new XfilFileCompareResult();
        for (XfilUriEntity uriEntity1 : uriEntityCollection) {
            String key1 = XfilFileCompareUtil.createKey(uriEntity1);
            XfilUriEntity uriEntity2 = uriEntityMap.get(key1);
            if (uriEntity2 == null) {
                compareResult.notExistList.add(uriEntity1);
                continue;
            }
            if (BcCompareUtil.compare(uriEntity1.size, uriEntity2.size) == BcCompareUtil.Comparison.equals.value) {
                compareResult.sameList.add(uriEntity1);
                continue;
            }
            compareResult.changedList.add(uriEntity1);
        }
        BcLogUtil.debug("notExistList.size()=" + compareResult.notExistList.size());
        BcLogUtil.debug("changedList.size()=" + compareResult.changedList.size());
        BcLogUtil.debug("sameList.size()=" + compareResult.sameList.size());
        return compareResult;
    }

    protected Map<String, XfilUriEntity> createMap(Collection<XfilUriEntity> uriEntityCollection) throws Exception {
        HashMap<String, XfilUriEntity> uriEntityMap = new HashMap<String, XfilUriEntity>();
        for (XfilUriEntity uriEntity : uriEntityCollection) {
            String key = XfilFileCompareUtil.createKey(uriEntity);
            uriEntityMap.put(key, uriEntity);
        }
        return uriEntityMap;
    }

    public static String createKey(XfilUriEntity uriEntity) {
        StringBuilder key = new StringBuilder();
        key.append(uriEntity.name);
        return key.toString();
    }
}

