/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcStringUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.server.XsysResultSetIterationTask;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class XsysCreateInsertSqlTask
extends XsysResultSetIterationTask {
    SqlContext sqlContext2;
    String insertBaseQuery;
    MmdModel mmdModel2;
    XdtsProcessCondition processCondition;
    Writer writer;

    public void setCondition(SqlContext sqlContext2, String insertBaseQuery, MmdModel mmdModel2, XdtsProcessCondition processCondition, Writer writer) throws Exception {
        this.sqlContext2 = sqlContext2;
        this.insertBaseQuery = insertBaseQuery;
        this.mmdModel2 = mmdModel2;
        this.processCondition = processCondition;
        this.writer = writer;
        insertBaseQuery = sqlContext2.createInsertQueryForPrepareStatement(mmdModel2, BcStringUtil.lineSeparator, true);
        this.getLogger().debug("insertBaseQuery=" + insertBaseQuery);
    }

    @Override
    protected void selected(ResultSet rs, int rowNumber) throws Exception {
        block2: {
            try {
                super.selected(rs, rowNumber);
                this.createInsertQuery(rs);
            }
            catch (Exception ex) {
                String stackTrace = BcLogUtil.getStackTrace(ex);
                this.getLogger().error(stackTrace);
                if (this.processCondition.ignoreException) break block2;
                throw ex;
            }
        }
    }

    @Override
    protected void finised(int rowNumber) throws Exception {
        super.finised(rowNumber);
        this.writer.write(59);
        this.writer.write(BcStringUtil.lineSeparator);
        this.writer.close();
    }

    public void createInsertQuery(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd1 = rs.getMetaData();
        StringBuilder insertQuery = new StringBuilder(this.insertBaseQuery);
        int i = 0;
        while (i < this.mmdModel2.getFieldCount()) {
            MmdField mmdField = this.mmdModel2.getField(this.mmdModel2.getFieldCount() - i - 1);
            insertQuery = this.createInsertSql_L2(rs, mmdField.ordinalPosition, insertQuery);
            ++i;
        }
        this.getLogger().debug("insertQuery=" + insertQuery);
        this.writer.write(insertQuery.toString());
        this.writer.write(59);
        this.writer.write(BcStringUtil.lineSeparator);
    }

    protected StringBuilder createInsertSql_L2(ResultSet rs, int colmunIndex, StringBuilder insertQuery) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int jdbcTypeId = rsmd.getColumnType(colmunIndex);
        String target = "?" + colmunIndex;
        String valueStr = null;
        switch (jdbcTypeId) {
            case 2005: 
            case 2011: {
                Clob clob = rs.getClob(colmunIndex);
                valueStr = this.clob(clob);
                if (valueStr != null) {
                    valueStr = this.sqlContext2.toSet(valueStr);
                }
                this.getLogger().debug("valueStr=" + valueStr);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                String hex = this.temp(rs.getBinaryStream(colmunIndex));
                if (BcStringUtil.isEmpty(hex)) break;
                valueStr = hex;
                break;
            }
            default: {
                Object value = rs.getObject(colmunIndex);
                if (value == null) break;
                valueStr = this.sqlContext2.toSet(value);
            }
        }
        insertQuery = BcStringUtil.isEmpty(valueStr) ? BcStringUtil.replace((CharSequence)insertQuery, target, "NULL") : BcStringUtil.replace((CharSequence)insertQuery, target, valueStr);
        return insertQuery;
    }

    protected String temp(InputStream is) throws Exception {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = BcStreamUtil.toBaos(is);
        byte[] bytes = baos.toByteArray();
        bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)i;
            ++i;
        }
        return this.sqlContext2.createBinaryInsert(bytes);
    }

    protected String clob(Clob clob) throws Exception {
        int ch;
        if (clob == null) {
            return null;
        }
        Reader reader = clob.getCharacterStream();
        StringBuffer buffer = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            buffer.append("" + (char)ch);
        }
        return buffer.toString();
    }
}

