/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.model.XdtsSchemaObjectTableModel;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;

class XdtsSchemaObjectSelectionPane
extends FxDecoratePane {
    XdtsSchemaObjectTableModel schemaObjectTableModel;
    FxTableView tableView;
    Button selectAllBbutton;
    Button releaseAllButton;

    public XdtsSchemaObjectSelectionPane() throws Exception {
        this.selectAllBbutton = this.createButton(BcWords.getInstance().selectAll.toPlain());
        this.releaseAllButton = this.createButton(BcWords.getInstance().releaseAll.toPlain());
        FxUtil.setPrefSize((Node)this.releaseAllButton);
    }

    public void setSchemaObjectList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        this.schemaObjectTableModel = new XdtsSchemaObjectTableModel();
        this.schemaObjectTableModel.tableContextList = schemaObjectList;
        FxTableRowList tableRowList = new FxTableRowList(this.schemaObjectTableModel);
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        this.tableView = new InnerTableView();
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.tableView.setEditable(true);
        this.setCenter((Node)this.tableView);
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = XdtsWords.getInstance().schemaObject;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 28;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().type;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().select;
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 6;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectAllBbutton) {
            this.setEenabledAll(true);
        } else if (ev.getSource() == this.releaseAllButton) {
            this.setEenabledAll(false);
        }
    }

    protected void setEenabledAll(boolean enabled) throws Exception {
        int i = 0;
        while (i < this.schemaObjectTableModel.tableContextList.size()) {
            XdtsSchemaObject tableContext = this.schemaObjectTableModel.tableContextList.get(i);
            tableContext.enabled = enabled;
            ++i;
        }
        this.tableView.refresh();
    }

    public List<XdtsSchemaObject> getSelecteSchemaObjectList() throws Exception {
        ArrayList<XdtsSchemaObject> schemaObjectList = new ArrayList<XdtsSchemaObject>();
        int i = 0;
        while (i < this.schemaObjectTableModel.tableContextList.size()) {
            XdtsSchemaObject schemaObject = this.schemaObjectTableModel.tableContextList.get(i);
            if (schemaObject.enabled) {
                schemaObjectList.add(schemaObject);
            }
            ++i;
        }
        return schemaObjectList;
    }

    class InnerTableView<S>
    extends FxTableView<S> {
    }
}

